package jp.co.sra.jun.goodies.pen;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.*;

/**
 * JunPenLocation class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/1/5 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPenLocation.java,v 8.11 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunPenLocation extends JunPenGeometry {
	private double x;
	private double y;
	private double z;

	/**
	 * Create a new instance of <code>JunPenLocation</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunPenLocation() {
		super();
		x = 0.0d;
		y = 0.0d;
		z = 0.0d;
	}

	/**
	 * Create a new instance of <code>JunPenLocation</code> and initialize it.
	 * 
	 * @param xNumber double
	 * @param yNumber double
	 * @param zNumber double
	 * @category Instance creation
	 */
	public JunPenLocation(double xNumber, double yNumber, double zNumber) {
		this();
		this.setX_(xNumber);
		this.setY_(yNumber);
		this.setZ_(zNumber);
	}
	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation Coerce_(double[] anObject) {
		return FromArray_(anObject);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation Coerce_(double anObject) {
		return FromNumber_(anObject);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation Coerce_(Object anObject) {
		Class thisClass = anObject.getClass();

		if (thisClass == JunPenLocation.class) {
			return (JunPenLocation) anObject;
		}

		if (thisClass == Jun2dPoint.class) {
			return FromPoint_((Jun2dPoint) anObject);
		}

		if (thisClass == Jun3dPoint.class) {
			return FromPoint_((Jun3dPoint) anObject);
		}

		if (thisClass == Double.class) {
			return FromNumber_(((Double) anObject).doubleValue());
		}

		Vector vector = (Vector) anObject;
		int size = vector.size();
		double[] anArray = new double[size];

		for (int index = 0; index < size; index++) {
			anArray[index] = ((Double) vector.elementAt(index)).doubleValue();
		}

		return FromArray_(anArray);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anArray DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation FromArray_(double[] anArray) {
		int length = anArray.length;
		JunPenLocation location = new JunPenLocation();

		if (length < 1) {
			return location;
		}

		location.setX_(anArray[0]);

		if (length < 2) {
			return location;
		}

		location.setY_(anArray[1]);

		if (length < 3) {
			return location;
		}

		location.setZ_(anArray[2]);

		return location;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation FromNumber_(double aNumber) {
		return X_y_z_(aNumber, aNumber, aNumber);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation FromPoint_(JunPoint aPoint) {
		double dX = 0.0d;
		double dY = 0.0d;
		double dZ = 0.0d;
		Class thisClass = aPoint.getClass();

		if (thisClass == Jun3dPoint.class) {
			Jun3dPoint point = (Jun3dPoint) aPoint;
			dX = point.x();
			dY = point.y();
			dZ = point.z();
		} else {
			if (thisClass == Jun2dPoint.class) {
				Jun2dPoint point = (Jun2dPoint) aPoint;
				dX = point.x();
				dY = point.y();
			} else {
				return null;
			}
		}

		return X_y_z_(dX, dY, dZ);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation Unity() {
		return X_y_z_(0.0d, 0.0d, 0.0d);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param xNumber DOCUMENT ME!
	 * @param yNumber DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation X_y_(double xNumber, double yNumber) {
		JunPenLocation location = new JunPenLocation();
		location.setX_(xNumber);
		location.setY_(yNumber);

		return location;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param xNumber DOCUMENT ME!
	 * @param yNumber DOCUMENT ME!
	 * @param zNumber DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenLocation X_y_z_(double xNumber, double yNumber, double zNumber) {
		JunPenLocation location = new JunPenLocation();
		location.setX_(xNumber);
		location.setY_(yNumber);
		location.setZ_(zNumber);

		return location;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static final JunPenLocation Zero() {
		return new JunPenLocation();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public Jun3dPoint _as3dPoint() {
		return new Jun3dPoint(this.x, this.y, this.z);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation abs() {
		return X_y_z_(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double[] asArray() {
		double[] array = new double[3];
		array[0] = this.x;
		array[1] = this.y;
		array[2] = this.z;

		return array;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public Jun2dPoint asPoint() {
		return new Jun2dPoint(this.x, this.y);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation ceiling() {
		return X_y_z_(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation dividedBy_(Object aLocation) {
		JunPenLocation theLocation = Coerce_(aLocation);

		return X_y_z_(this.x / theLocation.x(), this.y / theLocation.y(), this.z / theLocation.z());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation floor() {
		return X_y_z_(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation minus_(Object aLocation) {
		JunPenLocation theLocation = Coerce_(aLocation);

		return X_y_z_(this.x - theLocation.x(), this.y - theLocation.y(), this.z - theLocation.z());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation multipliedBy_(Object aLocation) {
		JunPenLocation theLocation = Coerce_(aLocation);

		return X_y_z_(this.x * theLocation.x(), this.y * theLocation.y(), this.z * theLocation.z());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation negated() {
		return X_y_z_(this.x * -1, this.y * -1, this.z * -1);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation plus_(Object aLocation) {
		JunPenLocation theLocation = Coerce_(aLocation);

		return X_y_z_(this.x + theLocation.x(), this.y + theLocation.y(), this.z + theLocation.z());
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation reciprocal() {
		return Unity().dividedBy_(this);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation rotatedBy_(Object aPoint) {
		return this.transform_(JunPenTransformation.Rotate_(aPoint));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation rounded() {
		return X_y_z_(Math.round(this.x), Math.round(this.y), Math.round(this.z));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLocation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation roundTo_(JunPenLocation aLocation) {
		return (this.dividedBy_(aLocation)).rounded().multipliedBy_(aLocation);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation scaledBy_(Object aPoint) {
		return this.transform_(JunPenTransformation.Scale_(aPoint));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setX_(double aNumber) {
		this.x = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setY_(double aNumber) {
		this.y = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aNumber DOCUMENT ME!
	 */
	public void setZ_(double aNumber) {
		this.z = aNumber;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aTransformation DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation transform_(JunPenTransformation aTransformation) {
		return aTransformation.applyToLocation_(this);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenLocation translatedBy_(Object aPoint) {
		return this.transform_(JunPenTransformation.Translate_(aPoint));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double x() {
		return this.x;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double y() {
		return this.y;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double z() {
		return this.z;
	}
}
