package jp.co.sra.jun.goodies.plotter;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.pen.JunPenTransformation;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunPlotterController class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/30 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/03/16 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPlotterController.java,v 8.11 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunPlotterController extends JunAbstractController implements MouseListener, MouseMotionListener {
	private Point _previousPoint;
	private Point _lastDownPoint;

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent event) {
		if (event.isPopupTrigger() || event.isMetaDown()) {
			super.mousePressed(event);
			return;
		}

		_previousPoint = _lastDownPoint;
		_lastDownPoint = event.getPoint();
		this.view().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
	}

	/**
	 * Invoked when a mouse button has been released. cursor reset to default.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent event) {
		if (event.isPopupTrigger() || event.isMetaDown()) {
			super.mouseReleased(event);
			return;
		}

		this.view().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		_previousPoint = null;
	}

	/**
	 * general dragging action.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 * @category mouse motion events
	 */
	public void mouseDragged(MouseEvent event) {
		if (!event.isMetaDown()) {
			this.scrollView_(event.getPoint());
		}
	}

	/**
	 * Reset view.
	 * 
	 * @category menu messages
	 */
	public void resetView() {
		this.plotterView().viewingTransformation_(null);
	}

	/**
	 * Scroll view.
	 * 
	 * @param currentPoint java.awt.Point
	 * @category menu messages
	 */
	public void scrollView_(Point currentPoint) {
		JunPenTransformation aTransformation = JunPenTransformation.Unity();
		aTransformation = aTransformation.product_(this.plotterView().viewingTransformation());
		if (_previousPoint == null) {
			_previousPoint = currentPoint;
		} else if (_previousPoint != currentPoint) {
			JunPenTransformation aT = JunPenTransformation.Translate_(new Jun2dPoint(currentPoint.x - _previousPoint.x, currentPoint.y - _previousPoint.y));
			aTransformation = aTransformation.product_(aT);
			this.plotterView().viewingTransformation_(aTransformation);
			_previousPoint = currentPoint;
		}
	}

	/**
	 * Zoom in.
	 * 
	 *  @category menu messages
	 */
	public void zoomIn() {
		JunPenTransformation aTransformation = JunPenTransformation.Unity();
		aTransformation = aTransformation.product_(this.plotterView().viewingTransformation());
		aTransformation = aTransformation.product_(JunPenTransformation.Scale_(new Double(2.0)));
		this.plotterView().viewingTransformation_(aTransformation);
	}

	/**
	 * Zoom out.
	 * 
	 *  @category menu messages
	 */
	public void zoomOut() {
		JunPenTransformation aTransformation = JunPenTransformation.Unity();
		aTransformation = aTransformation.product_(this.plotterView().viewingTransformation());
		aTransformation = aTransformation.product_(JunPenTransformation.Scale_(new Double(0.5)));
		this.plotterView().viewingTransformation_(aTransformation);
	}

	/**
	 * Answer plotter view object.
	 * 
	 * @return jp.co.sra.jun.goodies.plotter.JunPlotterView
	 * @category view accessing
	 */
	public JunPlotterView plotterView() {
		return (JunPlotterView) this.view();
	}

	/**
	 * Add listeners.
	 * 
	 * @param newView sra.mvctest.StView
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category view accessing
	 */
	protected void buildListener(StView newView) {
		Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}
}
