package jp.co.sra.jun.goodies.plotter;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.pen.JunPenTransformation;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunPlotterView interface
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/30 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2006/03/16 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPlotterView.java,v 8.10 2008/02/20 06:32:01 nisinaka Exp $
 */
public interface JunPlotterView extends JunAbstractView {
	/**
	 * Answer a model as JunPlotter.
	 * 
	 * @return jp.co.sra.jun.goodies.plotter.JunPlotter
	 * @category accessing
	 */
	public JunPlotter getModel();

	/**
	 * Answer origin point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint originPoint();

	/**
	 * Answer a JunTransformation object.
	 * 
	 * @return jp.co.sra.jun.goodies.pen.JunPenTransformation
	 * @category accessing
	 */
	public JunPenTransformation viewingTransformation();

	/**
	 * Set a JunTransformation object.
	 * 
	 * @param aTransformation jp.co.sra.jun.goodies.pen.JunPenTransformation
	 * @category accessing
	 */
	public void viewingTransformation_(JunPenTransformation aTransformation);
}
