package jp.co.sra.jun.goodies.prolog;

/**
 * JunPrologCharMap class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologCharMap.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologCharMap {

	protected static boolean[] SymbolMap;
	protected static boolean[] VariableMap;

	static {
		Initialize();
	}

	/**
	 * Answer the symbol map.
	 * 
	 * @return boolean[]
	 */
	public static boolean[] SymbolMap() {
		return SymbolMap;
	}

	/**
	 * Answer the variable map.
	 * 
	 * @return boolean[]
	 */
	public static boolean[] VariableMap() {
		return VariableMap;
	}

	/**
	 * Initialize the class.
	 */
	protected static void Initialize() {
		InitializeSymbolMap();
		InitializeVariableMap();
	}

	/**
	 * Initialize the symbol map.
	 */
	protected static void InitializeSymbolMap() {
		boolean[] newMap = new boolean[256];
		for (int i = 0; i < 256; i++) {
			newMap[i] = false;
		}

		for (char c = '0'; c <= '9'; c++) {
			newMap[c] = true;
		}
		for (char c = 'A'; c <= 'Z'; c++) {
			newMap[c] = true;
		}
		for (char c = 'a'; c <= 'z'; c++) {
			newMap[c] = true;
		}
		for (int i = 128; i < 256; i++) {
			newMap[i] = true;
		}
		newMap['+'] = true;
		newMap['-'] = true;
		newMap['!'] = true;
		newMap[':'] = true;
		newMap['*'] = true;
		newMap['/'] = true;
		newMap['\\'] = true;
		newMap['>'] = true;
		newMap['<'] = true;
		newMap['='] = true;
		newMap['_'] = true;
		newMap['$'] = true;

		SymbolMap = newMap;
	}

	/**
	 * Initialize the variable map.
	 */
	protected static void InitializeVariableMap() {
		boolean[] newMap = new boolean[256];
		for (int i = 0; i < 256; i++) {
			newMap[i] = false;
		}

		for (char c = '0'; c <= '9'; c++) {
			newMap[c] = true;
		}
		for (char c = 'A'; c <= 'Z'; c++) {
			newMap[c] = true;
		}
		for (char c = 'a'; c <= 'z'; c++) {
			newMap[c] = true;
		}
		newMap['~'] = true;

		VariableMap = newMap;
	}
}
