package jp.co.sra.jun.goodies.prolog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;
import jp.co.sra.smalltalk.menu.StPopupMenuViewSwing;

import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunPrologInterpreterViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/05/07 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologInterpreterViewSwing.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologInterpreterViewSwing extends JunAbstractViewJPanel implements JunPrologInterpreterView {

	protected JTextArea textValueView;
	protected JScrollPane textValueViewScrollPane;
	protected JTextArea textCollectorView;
	protected JScrollPane textCollectorViewScrollPane;

	/**
	 * Create a new instance of JunPrologInterpreterViewSwing and initialize it.
	 *
	 * @param aPrologInterpreter jp.co.sra.jun.goodies.prolog.JunPrologInterpreter
	 */
	public JunPrologInterpreterViewSwing(JunPrologInterpreter aPrologInterpreter) {
		super(aPrologInterpreter);
	}

	/**
	 * Answer my model as JunPrologInterpreter.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologInterpreter
	 */
	public JunPrologInterpreter getPrologInterpreter() {
		return (JunPrologInterpreter) this.model();
	}

	/**
	 * Answer the selected text to 'do it'.
	 *
	 * @return java.lang.String
	 */
	public String getSelectedText() {
		return this.textValueView().getSelectedText();
	}

	/**
	 * Set the bounds of myself and my components.
	 *
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);

		this.textValueViewScrollPane().setBounds(1, 1, width - 2, (int) (height * 0.3) - 2);
		this.textCollectorViewScrollPane().setBounds(1, (int) (height * 0.3), width - 2, (int) (height * 0.7) - 1);
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(null);
		this.add(this.textValueViewScrollPane());
		this.add(this.textCollectorViewScrollPane());
		this.setPreferredSize(new Dimension(350, 400));
	}

	/**
	 * Answer the view of my text collector.
	 *
	 * @return javax.swing.JTextArea
	 */
	protected JTextArea textCollectorView() {
		if (textCollectorView == null) {
			textCollectorView = new JTextArea("", 0, 0);
			textCollectorView.setBackground(Color.lightGray);

			ByteArrayOutputStream aByteArrayOutputStream = new ByteArrayOutputStream() {
				public synchronized void write(byte b[], int off, int len) {
					super.write(b, off, len);
					textCollectorView.append(new String(b, off, len));
				}
			};
			this.getPrologInterpreter().textCollector_(new PrintStream(aByteArrayOutputStream));
		}
		return textCollectorView;
	}

	/**
	 * Answer the scroll pane for the text collector view.
	 *
	 * @return javax.swing.JScrollPane
	 */
	protected JScrollPane textCollectorViewScrollPane() {
		if (textCollectorViewScrollPane == null) {
			textCollectorViewScrollPane = new JScrollPane(this.textCollectorView());
			textCollectorViewScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			textCollectorViewScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		}
		return textCollectorViewScrollPane;
	}

	/**
	 * Answer the view of my text value.
	 *
	 * @return javax.swing.JTextArea
	 */
	protected JTextArea textValueView() {
		if (textValueView == null) {
			textValueView = new JTextArea((String) this.getPrologInterpreter().textValue().value(), 0, 0);

			StPopupMenu aPopupMenu = new StPopupMenu();
			aPopupMenu.add(new StMenuItem("do it", new MenuPerformer(this.getPrologInterpreter(), "doIt", this)));

			final JPopupMenu aPopupMneu = new StPopupMenuViewSwing(aPopupMenu).toPopupMenu();
			textValueView.add(aPopupMneu);
			textValueView.addMouseListener(new MouseAdapter() {
				public void mousePressed(MouseEvent e) {
					if (e.isMetaDown() || e.isPopupTrigger()) {
						aPopupMneu.show(textValueView, e.getX(), e.getY());
					}
				}
			});

			this.getPrologInterpreter().textValue().compute_(new StBlockClosure() {
				public Object value_(Object newValue) {
					textValueView.setText((String) newValue);
					return null;
				}
			});
		}
		return textValueView;
	}

	/**
	 * Answer the scroll pane for the text value view.
	 *
	 * @return javax.swing.JScrollPane
	 */
	protected JScrollPane textValueViewScrollPane() {
		if (textValueViewScrollPane == null) {
			textValueViewScrollPane = new JScrollPane(this.textValueView());
			textValueViewScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			textValueViewScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		}
		return textValueViewScrollPane;
	}
}
