package jp.co.sra.jun.goodies.soroban;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunSorobanViewAwt class
 * 
 *  @author    m-asada
 *  @created   2006/03/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun563 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSorobanViewAwt.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSorobanViewAwt extends JunAbstractViewPanel implements JunSorobanView {
	protected StDisplayable[] reedImages;
	protected StDisplayable markImage;

	/**
	 * Create a new instance of <code>JunSorobanViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSorobanViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSorobanViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.soroban.JunSorobanModel
	 * @category Instance creation
	 */
	public JunSorobanViewAwt(JunSorobanModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the koma image height.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#komaHeight()
	 * @category accessing
	 */
	public int komaHeight() {
		return JunSorobanModel.KomaHeight();
	}

	/**
	 * Answer the kushi image height.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#kushiHeight()
	 * @category accessing
	 */
	public int kushiHeight() {
		return JunSorobanModel.KushiHeight();
	}

	/**
	 * Answer the margin rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#marginRectangle()
	 * @category accessing
	 */
	public StRectangle marginRectangle() {
		return StRectangle.Origin_corner_(new Point(9, 9), new Point(9, 9));
	}

	/**
	 * Answer the mark image.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable markImage() {
		return JunSorobanModel.MarkImage();
	}

	/**
	 * Answer the reed image height.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#reedHeight()
	 * @category accessing
	 */
	public int reedHeight() {
		return JunSorobanModel.ReedHeight();
	}

	/**
	 * Answer the reed images.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable[]
	 * @category accessing
	 */
	public StDisplayable[] reedImages() {
		if (reedImages == null) {
			reedImages = new StDisplayable[JunSorobanModel.ReedImages().length];
			for (int i = 0; i < reedImages.length; i++) {
				reedImages[i] = new StImage(JunSorobanModel.ReedImages()[i].asImage().image());
			}
		}
		return reedImages;
	}

	/**
	 * Answer the reed image width.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#reedWidth()
	 * @category accessing
	 */
	public int reedWidth() {
		return JunSorobanModel.ReedWidth();
	}

	/**
	 * Returns the preferred size of this container.  
	 * 
	 * @return java.awt.Dimension
	 * @see java.awt.Component#getPreferredSize()
	 * @category bounds accessing
	 */
	public Dimension getPreferredSize() {
		return new Dimension(498, 120);
	}

	/**
	 * Answer the receiver's default controller as JunSorobanController.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunSorobanController();
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param graphcisContext java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics graphcisContext) {
		StRectangle[] boxes = new StRectangle(this.getPreferredSize()).insetBy_(3).areasOutside_(new StRectangle(this.getPreferredSize()).insetBy_(this.marginRectangle()));
		for (int i = 0; i < boxes.length; i++) {
			graphcisContext.fillRect(boxes[i].x(), boxes[i].y(), boxes[i].width(), boxes[i].height());
		}
		for (int i = 0; i < this.getModel().reeds(); i++) {
			this.displayOn_reed_(graphcisContext, i);
		}
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param graphcisContext java.awt.Graphics
	 * @param reedNumber int
	 * @category displaying
	 */
	public void displayOn_reed_(Graphics graphcisContext, int reedNumber) {
		int xValue = reedNumber * this.reedWidth() + this.marginRectangle().originX();
		this.reedImages()[this.getModel().at_(reedNumber)].displayOn_at_(graphcisContext, new Point(xValue, this.marginRectangle().originY()));
		if ((reedNumber + 1) % 3 == 0) {
			this.markImage().displayOn_at_(graphcisContext, new Point(xValue, 33));
		}
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		reedImages = null;
		markImage = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(null);
		this.setSize(this.getPreferredSize());
	}

	/**
	 * Answer the receiver's model as JunSorobanModel.
	 * 
	 * @return jp.co.sra.jun.goodies.soroban.JunSorobanModel
	 * @see jp.co.sra.jun.goodies.soroban.JunSorobanView#getModel()
	 * @category model accessing
	 */
	public JunSorobanModel getModel() {
		return (JunSorobanModel) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("value")) {
			int reedNumber = ((Number) evt.getParameter()).intValue();
			Graphics aGraphics = this.getGraphics();
			try {
				this.displayOn_reed_(aGraphics, reedNumber);
			} finally {
				if (aGraphics != null) {
					aGraphics.dispose();
					aGraphics = null;
				}
			}
			return;
		}
		super.update_(evt);
	}
}
