package jp.co.sra.jun.goodies.sound;

import java.awt.Dimension;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunSoundMeterViewSwing class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/29 (by Hoshi Takanori)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSoundMeterViewSwing.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSoundMeterViewSwing extends JunAbstractViewJPanel implements JunSoundMeterView {

	protected JunSoundLevelMeterViewSwing soundLevelMeterView;
	protected JunSoundWaveMeterViewSwing soundWaveMeterView;

	/**
	 * Create a new instance of JunSoundMeterViewSwing and initialize it.
	 *
	 * @param aSoundMeterModel jp.co.sra.jun.goodies.sound.JunSoundMeterModel
	 */
	public JunSoundMeterViewSwing(JunSoundMeterModel aSoundMeterModel) {
		super(aSoundMeterModel);
	}

	/**
	 * Answer my model as JunSoundMeterModel.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundMeterModel
	 */
	public JunSoundMeterModel getSoundMeterModel() {
		return (JunSoundMeterModel) this.model();
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.soundWaveMeterView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -11));
		this.add(this.soundLevelMeterView(), WindowSpecLayout.Position(0f, 1, 1f, -10, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(500, 64));
	}

	/**
	 * Answer the sound level meter view.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundLevelMeterViewSwing
	 */
	protected JunSoundLevelMeterViewSwing soundLevelMeterView() {
		if (soundLevelMeterView == null) {
			soundLevelMeterView = new JunSoundLevelMeterViewSwing(this.getSoundMeterModel());
		}
		return soundLevelMeterView;
	}

	/**
	 * Answer the sound wave meter view.
	 *
	 * @return jp.co.sra.jun.goodies.sound.JunSoundWaveMeterViewSwing
	 */
	protected JunSoundWaveMeterViewSwing soundWaveMeterView() {
		if (soundWaveMeterView == null) {
			soundWaveMeterView = new JunSoundWaveMeterViewSwing(this.getSoundMeterModel());
		}
		return soundWaveMeterView;
	}
}
