package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSpiroCircleTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/03/29 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroCircleTestExamples.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroCircleTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSpiroCircle spiroCircle = new JunSpiroCircle();
		JunDisplayModel aModel = new JunDisplayModel(spiroCircle);
		aModel.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunSpiroCircle spiroCircle = new JunSpiroCircle(new Jun2dPoint(100, 100), 80);
		JunDisplayModel aModel = new JunDisplayModel(spiroCircle);
		aModel.open();
		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunSpiroCircle spiroCircle = new JunSpiroCircle(new Jun2dPoint(100, 100), 80, Color.red, 10);
		JunDisplayModel aModel = new JunDisplayModel(spiroCircle);
		aModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSpiroCircleTestExamples();
	}
}
