package jp.co.sra.jun.goodies.spirodesign;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorDialog;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunSpiroDesign class
 * 
 *  @author    m-asada
 *  @created   2006/03/28 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun681 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesign.java,v 8.12 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesign extends JunSpiroDesignAbstractModel {
	protected JunSpiroCircle teraCircle;
	protected JunSpiroCircle moonCircle;
	protected JunSpiroPen spiroPen;
	protected boolean isCircumscribe;
	protected int howMany;
	protected boolean animationState;
	protected StValueHolder animationHolder;
	protected transient JunSpiroDesignAnimationThread _spiroDesignProcess;

	protected transient StPopupMenu _popupMenu;

	/**
	 * Create a new instance of <code>JunSpiroDesign</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSpiroDesign() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSpiroDesign</code> and initialize it.
	 * 
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunSpiroDesign(Color aColor) {
		this(aColor, 1);
	}

	/**
	 * Create a new instance of <code>JunSpiroDesign</code> and initialize it.
	 * 
	 * @param aColor java.awt.Color
	 * @param aWidth int
	 * @category Instance creation
	 */
	public JunSpiroDesign(Color aColor, int aWidth) {
		super();
		this.spiroPen().color_(aColor);
		this.spiroPen().width_(aWidth);
	}

	/**
	 * Create a new instance of <code>JunSpiroDesign</code> and initialize it.
	 * 
	 * @param teraCircle jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @param moonCircle jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @param spiroPen jp.co.sra.jun.goodies.spirodesign.JunSpiroPen
	 * @category Instance creation
	 */
	public JunSpiroDesign(JunSpiroCircle teraCircle, JunSpiroCircle moonCircle, JunSpiroPen spiroPen) {
		super();
		this.setTeraCircle_(teraCircle);
		this.setMoonCircle_(moonCircle);
		this.setSpiroPen_(spiroPen);
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		teraCircle = null;
		moonCircle = null;
		spiroPen = null;
		isCircumscribe = false;
		howMany = 36;
		animationState = false;
		animationHolder = null;
		_spiroDesignProcess = null;

		_popupMenu = null;
	}

	/**
	 * Answer the receiver's color.
	 * 
	 * @return java.awt.Color
	 * @category accessing
	 */
	public Color color() {
		return this.spiroPen().color();
	}

	/**
	 * Set the receiver's color and width.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber int
	 * @category accessing
	 */
	public void color_width_(Color aColor, int aNumber) {
		this.spiroPen().color_(aColor);
		this.spiroPen().width_(aNumber);
		if (this.animationHolder().value() != null) {
			JunSpiroDesign spiroDesign = (JunSpiroDesign) this.animationHolder().value();
			spiroDesign.spiroPen().color_(this.spiroPen().color());
			spiroDesign.spiroPen().width_(this.spiroPen().width());
		}
	}

	/**
	 * Answer the receiver's how many.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int howMany() {
		return howMany;
	}

	/**
	 * Set the receiver's how many.
	 * 
	 * @param aNumber int
	 * @category accessing
	 */
	public void howMany_(int aNumber) {
		howMany = aNumber;
	}

	/**
	 * Answer the receiver's how many circle.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int howManyCircle() {
		return 36;
	}

	/**
	 * Answer the receiver's moon circle.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#moonCircle()
	 * @category accessing
	 */
	public JunSpiroCircle moonCircle() {
		if (moonCircle == null) {
			int radius = 70;
			Jun2dPoint center = new Jun2dPoint(this.teraCircle().radius() - radius, 0);
			moonCircle = new JunSpiroCircle(center, radius, Color.blue, 1);
		}
		return moonCircle;
	}

	/**
	 * Anser the receiver's point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint point() {
		return this.spiroPen().point();
	}

	/**
	 * Answer true if the receiver's color is rainbow, otherwise false.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean rainbow() {
		return this.spiroPen().rainbow();
	}

	/**
	 * Set the receiver's rainbow color.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void rainbow_(boolean aBoolean) {
		this.spiroPen().rainbow_(aBoolean);
		if (this.animationHolder().value() != null) {
			JunSpiroDesign spiroDesign = (JunSpiroDesign) this.animationHolder().value();
			spiroDesign.spiroPen().rainbow_(this.spiroPen().rainbow());
		}
	}

	/**
	 * Answer the receiver's spiro pen.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroPen
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#spiroPen()
	 * @category accessing
	 */
	public JunSpiroPen spiroPen() {
		if (spiroPen == null) {
			spiroPen = new JunSpiroPen(this.moonCircle().center().plus_(new Jun2dPoint(-20, 50)));
		}
		return spiroPen;
	}

	/**
	 * Answer the receiver's tera circle.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#teraCircle()
	 * @category accessing
	 */
	public JunSpiroCircle teraCircle() {
		if (teraCircle == null) {
			teraCircle = new JunSpiroCircle(new Jun2dPoint(0, 0), 120, Color.red, 1);
		}
		return teraCircle;
	}

	/**
	 * Answer the receiver's width.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int width() {
		return this.spiroPen().width();
	}

	/**
	 * Answer the receiver's animation holder.
	 * 
	 * @return animationHolder
	 * @category aspects
	 */
	public StValueHolder animationHolder() {
		if (animationHolder == null) {
			animationHolder = new StValueHolder();
		}
		return animationHolder;
	}

	/**
	 * Answer the receiver's bounding box.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle boundingBox() {
		Rectangle aBox = this.teraCircle().boundingBox();
		if (this.isCircumscribe()) {
			aBox.grow(this.moonCircle().boundingBox().width, this.moonCircle().boundingBox().height);
		}
		aBox.add(this.spiroPen().mark());
		return aBox;
	}

	/**
	 * Answer the bounding box of the receiver.
	 *
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#bounds()
	 * @category bounds accessing
	 */
	public Rectangle bounds() {
		return this.preferredBounds();
	}

	/**
	 * Answer the receiver's preferred bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle preferredBounds() {
		Rectangle aBox = this.teraCircle().bounds();
		if (this.isCircumscribe()) {
			aBox.grow(this.moonCircle().bounds().width, this.moonCircle().bounds().height);
		}
		aBox.add(this.spiroPen().mark());
		return aBox;
	}

	/**
	 * Set the specified computes block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category constructing
	 */
	public void compute_(StBlockClosure aBlock) {
		this.animationHolder().compute_(aBlock);
	}

	/**
	 * Answer the default image quality.
	 * 
	 * @return float
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#defaultImageQuality()
	 * @category defaults
	 */
	public float defaultImageQuality() {
		return 0.95f;
	}

	/**
	 * Answer the default locus interval
	 * 
	 * @return jp.co.sra.smalltalk.StInterval
	 * @category defaults
	 */
	public StInterval defaultLocusInterval() {
		return new StInterval(0, 360 * this.howMany(), JunSpiroPen.DefaultTickAngle);
	}

	/**
	 * Answer the default tick time.
	 * 
	 * @return long
	 * @category defaults
	 */
	public long defaultTickTime() {
		return 50L;
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#displayOn_at_(java.awt.Graphics, java.awt.Point)
	 * @category displaying
	 */
	public void displayOn_at_(Graphics graphicsContext, Point displayPoint) {
		this.displayOn_at_withParts_(graphicsContext, displayPoint, true);
	}

	/**
	 * Display the specified tera circle and moon circle on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @param aTera jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @param aMoon jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @category displaying
	 */
	public void displayOn_at_betweenTera_andMoon_(Graphics graphicsContext, Point displayPoint, JunSpiroCircle aTera, JunSpiroCircle aMoon) {
		Jun2dPoint[] pointArray = aMoon.points();
		for (int i = 0; i < pointArray.length; i++) {
			pointArray[i] = pointArray[i].rounded().translatedBy_(new Jun2dPoint(displayPoint));
		}
		Graphics2D aGraphics = (Graphics2D) graphicsContext.create();
		try {
			this.applyAttributesToGraphicsContext_(aGraphics);
			aGraphics.drawLine((int) Math.round(aTera.center().x() + displayPoint.x), (int) Math.round(aTera.center().y() + displayPoint.y), (int) Math.round(pointArray[0].x()), (int) Math.round(pointArray[0].y()));
			aGraphics.drawLine((int) Math.round(pointArray[1].x()), (int) Math.round(pointArray[1].y()), (int) Math.round(pointArray[3].x()), (int) Math.round(pointArray[3].y()));
			aGraphics.drawLine((int) Math.round(pointArray[2].x()), (int) Math.round(pointArray[2].y()), (int) Math.round(pointArray[4].x()), (int) Math.round(pointArray[4].y()));
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
				aGraphics = null;
			}
		}
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @param aBoolean boolean
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#displayOn_at_withParts_(java.awt.Graphics, java.awt.Point, boolean)
	 * @category displaying
	 */
	public void displayOn_at_withParts_(Graphics graphicsContext, Point displayPoint, boolean aBoolean) {
		if (this.animationState()) {
			this.displayOn_at_withParts_spiroDesign_(graphicsContext, displayPoint, aBoolean, (JunSpiroDesign) this.animationHolder().value());
		} else {
			JunSpiroPen aSpiroPen = (JunSpiroPen) this.spiroPen().copy();
			aSpiroPen.points_(this.spiroLocus());
			aSpiroPen.displayOn_at_with_Marks_(graphicsContext, displayPoint, false);
			if (aBoolean) {
				this.displayOn_at_betweenTera_andMoon_(graphicsContext, displayPoint, this.teraCircle(), this.moonCircle());
				this.teraCircle().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
				this.moonCircle().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
				this.spiroPen().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
			}
		}
	}

	/**
	 * Display the specified spiro design on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @param aBoolean boolean
	 * @param spiroDesign jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category displaying
	 */
	public void displayOn_at_withParts_spiroDesign_(Graphics graphicsContext, Point displayPoint, boolean aBoolean, JunSpiroDesign spiroDesign) {
		if (spiroDesign == null) {
			return;
		}
		spiroDesign.spiroPen().displayOn_at_with_Marks_(graphicsContext, displayPoint, false);
		if (aBoolean) {
			this.displayOn_at_betweenTera_andMoon_(graphicsContext, displayPoint, spiroDesign.teraCircle(), spiroDesign.moonCircle());
			spiroDesign.teraCircle().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
			spiroDesign.moonCircle().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
			spiroDesign.spiroPen().displayOn_at_with_Marks_(graphicsContext, displayPoint, true);
		}
	}

	/**
	 * Answer the receiver's animationState.
	 * 
	 * @return animationState
	 * @category functions
	 */
	public boolean animationState() {
		return animationState;
	}

	/**
	 * Set the receiver's animationState.
	 * 
	 * @param aBoolean boolean
	 * @category functions
	 */
	public void animationState_(boolean aBoolean) {
		animationState = aBoolean;
	}

	/**
	 * Do animation on the receiver and the specified views.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param viewCollection jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView[]
	 * @deprecated using JunSpiroDesignAnimaitonThread(jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign, jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView[], jp.co.sra.smalltalk.StBlockClosure)
	 * @category functions
	 */
	public void doAnimation_onViews_(final StBlockClosure aBlock, final JunSpiroDesignView[] viewCollection) {
		try {
			final JunSpiroDesign self = this;
			this.animationState_(true);

			final boolean alt = StInputState.Default().altDown();
			final boolean shift = StInputState.Default().shiftDown();
			final File directory = new File(JunFileModel.DefaultDirectory(), self.defaultBaseName());
			final StValueHolder indexHolder = new StValueHolder(1);
			if (alt) {
				if (directory.exists() == false) {
					directory.mkdir();
				}
			}
			final Rectangle previous = this.bounds();
			this.spiroLocusInterim_(new StBlockClosure() {
				public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
					JunSpiroCircle tera = (JunSpiroCircle) obj1;
					JunSpiroCircle moon = (JunSpiroCircle) obj2;
					JunSpiroPen pen = (JunSpiroPen) obj3;

					self.animationHolder().value_(new JunSpiroDesign(tera, moon, pen));
					Rectangle current = moon.bounds();
					current.add(pen.mark());
					current.add(tera.mark());

					Rectangle parameter = new Rectangle(previous);
					parameter.add(current);
					for (int i = 0; i < viewCollection.length; i++) {
						viewCollection[i].update_(new DependentEvent(this, $("invalidate"), new Rectangle(parameter)));
					}
					previous.setBounds(current);
					if (aBlock != null) {
						Object anObject = aBlock.value();
						if (anObject != null) {
							throw new RuntimeException("Alt/Shift key event is happend.");
						}
					}
					if (alt) {
						StImage image = self.asImageWithParts();
						if (shift) {
							image = JunImageAdjuster.Adjust_extent_(image, new Dimension(image.width() / 2, image.height() / 2));
						}
						String string = new DecimalFormat("00000000").format(indexHolder._intValue());
						File file = new File(directory, string + ".jpg");
						JunImageStream stream = null;
						JunCursors cursor = new JunCursors(JunCursors.ExecuteCursor());
						try {
							cursor._show();
							stream = JunJpegImageStream.On_(new FileOutputStream(file));
							stream.nextPutImage_(image);
						} catch (IOException e) {
							System.err.println(e.getMessage());
							e.printStackTrace();
						} finally {
							if (stream != null) {
								try {
									stream.flush();
									stream.close();
								} catch (IOException e) {
								}
								stream = null;
							}
							cursor._restore();
						}
						indexHolder.value_(indexHolder._intValue() + 1);
					}
					try {
						Thread.sleep(self.defaultTickTime());
					} catch (InterruptedException e) {
					}
					return null;
				}
			});
			try {
				Thread.sleep(3000);
			} catch (InterruptedException e) {
			}
		} catch (RuntimeException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		} finally {
			this.animationState_(false);
			this.changed_($("spiroDesign"));
		}
	}

	/**
	 * Answer the collection of spiro locus.
	 * 
	 * @return java.util.Collection
	 * @category functions
	 */
	public Collection spiroLocus() {
		return this.spiroLocusInterim_(new StBlockClosure() {
			public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
				// JunSpiroCircle tera = (JunSpiroCircle) obj1;
				// JunSpiroCircle moon = (JunSpiroCircle) obj2;
				// JunSpiroPen pen = (JunSpiroPen) obj3;
				return null;
			}
		});
	}

	/**
	 * Answer the collection of spiro locus interim the specified block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.util.Collection
	 * @category functions
	 */
	public Collection spiroLocusInterim_(final StBlockClosure aBlock) {
		final double ratio = (Math.abs(this.moonCircle().circumference()) < JunGeometry.Accuracy()) ? 0.0d : (this.teraCircle().circumference() / this.moonCircle().circumference());
		final Jun2dPoint offset = this.spiroPen().point().minus_(this.moonCircle().center());
		StInterval interval = this.defaultLocusInterval();
		final Collection locus = new ArrayList(interval.size());
		final JunSpiroDesign self = this;
		interval.do_(new StBlockClosure() {
			public Object value_(Object obj) {
				int degrees = ((Number) obj).intValue();
				double angle = degrees * ratio;
				if (self.isInscribe()) {
					angle = 0 - angle;
				}
				angle = angle + degrees;
				Jun2dPoint center = new Jun2dPoint(self.moonCircle().center().x(), self.moonCircle().center().y()).transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(degrees), self.teraCircle().center()));
				Jun2dPoint point = new Jun2dPoint(offset.x(), offset.y()).transform_(Jun2dTransformation.Rotate_around_(JunAngle.FromDeg_(angle), new Jun2dPoint(0, 0)));
				point = point.plus_(center);
				center = new Jun2dPoint(center.x(), center.y());
				point = new Jun2dPoint(point.x(), point.y());
				locus.add(point);
				if (aBlock != null) {
					JunSpiroCircle tera = (JunSpiroCircle) self.teraCircle().copy();
					JunSpiroCircle moon = (JunSpiroCircle) self.moonCircle().copy();
					moon.center_(center);
					moon.angle_(angle);
					JunSpiroPen pen = (JunSpiroPen) self.spiroPen().copy();
					pen.points_(new ArrayList(locus));
					aBlock.value_value_value_(tera, moon, pen);
				}
				Thread.yield();
				return null;
			}
		});
		return locus;
	}

	/**
	 * Update the menu indication.
	 * 
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#updateMenuIndication_(jp.co.sra.smalltalk.menu.StMenu)
	 * @category menu accessing
	 */
	public StMenu updateMenuIndication_(StMenu aMenu) {
		if (aMenu == null) {
			return null;
		}

		StMenuItem menuElement = (StMenuItem) aMenu.atNameKey_($("doAnimation"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				menuElement.beEnabled(true);
			}
		}

		menuElement = aMenu.atNameKey_($("beInscribe"));
		if (menuElement != null) {
			if (this.isInscribe()) {
				menuElement.beEnabled(false);
			} else {
				menuElement.beEnabled(true);
			}
		}

		menuElement = aMenu.atNameKey_($("beCircumscribe"));
		if (menuElement != null) {
			if (this.isCircumscribe()) {
				menuElement.beEnabled(false);
			} else {
				menuElement.beEnabled(true);
			}
		}

		menuElement = aMenu.atNameKey_($("toggleRainbow"));
		if (menuElement != null) {
			if (this.isRainbow()) {
				((StCheckBoxMenuItem) menuElement).beOn();
			} else {
				((StCheckBoxMenuItem) menuElement).beOff();
			}
		}

		return aMenu;
	}

	/**
	 * Set the receiver be circumscribe.
	 * 
	 * @category menu messages
	 */
	public void beCircumscribe() {
		isCircumscribe = true;
		Jun2dPoint tera = this.teraCircle().center();
		Jun2dPoint moon = this.moonCircle().center();
		Jun2dLine line = new Jun2dLine(tera, moon).normalized();
		Jun2dPoint center = line.atT_(this.teraCircle().radius() + this.moonCircle().radius());
		this.moonCircle().center_(center);
		this.pointOfSpiroPen_(this.spiroPen().point());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver be inscribe.
	 * 
	 * @category menu messages
	 */
	public void beInscribe() {
		isCircumscribe = false;
		Jun2dPoint tera = this.teraCircle().center();
		Jun2dPoint moon = this.moonCircle().center();
		if (this.teraCircle().radius() > this.moonCircle().radius()) {
			Jun2dLine line = new Jun2dLine(tera, moon).normalized();
			Jun2dPoint center = line.atT_(this.teraCircle().radius() - this.moonCircle().radius());
			this.moonCircle().center_(center);
		} else {
			Jun2dLine line = new Jun2dLine(tera, moon).normalized();
			double distance = this.moonCircle().center().distance_(this.teraCircle().center());
			Jun2dPoint point = line.atT_(distance + this.moonCircle().radius());
			this.teraCircle().radius_(point.distance_(this.teraCircle().center()));
		}
		this.pointOfSpiroPen_(this.spiroPen().point());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver be one color.
	 * 
	 * @category menu messages
	 */
	public void beOneColor() {
		this.spiroPen().rainbow_(false);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver be rainbow color.
	 * 
	 * @category menu messages
	 */
	public void beRainbowColor() {
		this.spiroPen().rainbow_(true);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Open the choice nib dialog.
	 * 
	 * @category menu messages
	 */
	public void choiceNib() {
		Object[] answer = (Object[]) JunNibChoiceWithColorDialog.Request($String("Select nib."), new JunNibChoiceWithColor(new double[] { 1, 2, 3, 4, 5 }, this.spiroPen().width(), this.spiroPen().color(), $("rectangle")));
		if (answer == null) {
			return;
		}

		int width = ((Number) answer[1]).intValue();
		Color color = (Color) answer[2];
		this.spiroPen().width_(width);
		this.spiroPen().color_(color);
		this.beOneColor();
	}

	/**
	 * Do animation on the reciver.
	 * 
	 * @category menu messages
	 */
	public synchronized void doAnimation() {
		_spiroDesignProcess = new JunSpiroDesignAnimationThread(this, this.getSpiroDesignViews(), null) {
			MouseListener[] mouseListeners;

			public void run() {
				try {
					JunSpiroDesignView[] views = this.spiroDesignViews();
					mouseListeners = new JunAbstractController[views.length];
					for (int i = 0; i < views.length; i++) {
						mouseListeners[i] = new JunAbstractController() {
							public void mousePressed(MouseEvent evt) {
								_spiroDesignProcess.animationSuspend();
							}

							public void mouseReleased(MouseEvent evt) {
								if (evt.isAltDown() == false) {
									_spiroDesignProcess.animationStop();
								} else {
									_spiroDesignProcess.animationResume();
								}
							}
						};
						views[i].toComponent().addMouseListener(mouseListeners[i]);
					}
					super.run();
				} finally {
					if (_spiroDesignProcess != null) {
						this.animationStop();
					}
				}
			}

			public void animationStop() {
				super.animationStop();
				if (mouseListeners != null) {
					JunSpiroDesignView[] views = this.spiroDesignViews();
					for (int i = 0; i < views.length; i++) {
						views[i].toComponent().removeMouseListener(mouseListeners[i]);
					}
					mouseListeners = null;
				}
				_spiroDesignProcess.yield();
				_spiroDesignProcess = null;
				this.spiroDesign().changed_(StSymbol.$("spiroDesign"));
			}
		};
		_spiroDesignProcess.start();
	}

	/**
	 * Toggle the receiver's rainbow.
	 * 
	 * @category menu messages
	 */
	public void toggleRainbow() {
		this.rainbow_(!this.rainbow());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's center of moon circle with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#centerOfMoonCircle_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void centerOfMoonCircle_(Jun2dPoint aPoint) {
		Jun2dPoint delta = aPoint.minus_(this.moonCircle().center());
		if (this.isInscribe()) {
			this.moonCircle().center_(aPoint);
			double distance = this.moonCircle().center().distance_(this.teraCircle().center());
			this.teraCircle().radius_(distance + this.moonCircle().radius());
		} else {
			double distance = aPoint.distance_(this.teraCircle().center());
			if (distance >= this.moonCircle().radius()) {
				this.moonCircle().center_(aPoint);
				distance = this.moonCircle().center().distance_(this.teraCircle().center());
				this.teraCircle().radius_(distance - this.moonCircle().radius());
			} else {
				Jun2dPoint tera = this.teraCircle().center();
				Jun2dPoint moon = this.moonCircle().center();
				Jun2dLine line = new Jun2dLine(tera, moon).normalized();
				Jun2dPoint center = line.atT_(this.moonCircle().radius());
				this.moonCircle().center_(center);
				this.teraCircle().radius_(0);
				delta = center.minus_(this.moonCircle().center());
			}
		}
		this.pointOfSpiroPen_(this.spiroPen().point().plus_(delta));
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's center of tera circle with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#centerOfTeraCircle_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void centerOfTeraCircle_(Jun2dPoint aPoint) {
		Jun2dPoint delta = aPoint.minus_(this.teraCircle().center());
		this.moonCircle().center_(this.moonCircle().center().plus_(delta));
		this.teraCircle().center_(aPoint);
		this.pointOfSpiroPen_(this.spiroPen().point().plus_(delta));
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's point of spiro pen with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#pointOfSpiroPen_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void pointOfSpiroPen_(Jun2dPoint aPoint) {
		double radius = this.moonCircle().radius();
		Jun2dPoint center = this.moonCircle().center();
		Jun2dPoint point = null;
		if (aPoint.distance_(center) > radius) {
			Jun2dLine line = new Jun2dLine(center, aPoint).normalized();
			point = line.atT_(radius);
		} else {
			point = aPoint;
		}
		this.spiroPen().point_(point);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's radius of moon circle with the specified number.
	 * 
	 * @param aNumber double
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#radiusOfMoonCircle_(double)
	 * @category setting
	 */
	public void radiusOfMoonCircle_(double aNumber) {
		double distance = this.moonCircle().center().distance_(this.teraCircle().center());
		if (this.isInscribe()) {
			this.moonCircle().radius_(aNumber);
			this.teraCircle().radius_(distance + this.moonCircle().radius());
		} else {
			this.moonCircle().radius_(Math.min(aNumber, distance));
			this.teraCircle().radius_(distance - this.moonCircle().radius());
		}
		this.pointOfSpiroPen_(this.spiroPen().point());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's radius of tera circle with the specified number.
	 * 
	 * @param aNumber double
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#radiusOfTeraCircle_(double)
	 * @category setting
	 */
	public void radiusOfTeraCircle_(double aNumber) {
		double distance = this.moonCircle().center().distance_(this.teraCircle().center());
		if (this.isInscribe()) {
			this.teraCircle().radius_(Math.max(aNumber, distance));
			this.moonCircle().radius_(this.teraCircle().radius() - distance);
		} else {
			this.teraCircle().radius_(Math.min(aNumber, distance));
			this.moonCircle().radius_(distance - this.teraCircle().radius());
		}
		this.pointOfSpiroPen_(this.spiroPen().point());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver's moon circle.
	 * 
	 * @param aSpiroCircle jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @category setting
	 */
	protected void setMoonCircle_(JunSpiroCircle aSpiroCircle) {
		moonCircle = aSpiroCircle;
		if (this.teraCircle().center().distance_(this.moonCircle().center()) > this.teraCircle().radius()) {
			isCircumscribe = true;
		} else {
			isCircumscribe = false;
		}
	}

	/**
	 * Set the receiver's spiro pen.
	 * 
	 * @param aSpiroPen jp.co.sra.jun.goodies.spirodesign.JunSpiroPen
	 * @category setting
	 */
	protected void setSpiroPen_(JunSpiroPen aSpiroPen) {
		spiroPen = aSpiroPen;
	}

	/**
	 * Set the receiver's tera circle.
	 * 
	 * @param aSpiroCircle jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @category setting
	 */
	protected void setTeraCircle_(JunSpiroCircle aSpiroCircle) {
		teraCircle = aSpiroCircle;
	}

	/**
	 * Answer true if the receiver is active spiro design process, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isActiveSpiroDesignProcess() {
		return false;
	}

	/**
	 * Answer true if the receiver is circumscribe, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isCircumscribe() {
		return isCircumscribe;
	}

	/**
	 * Answer true if the receiver is inscribe, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isInscribe() {
		return this.isCircumscribe() == false;
	}

	/**
	 * Answer true if the receiver's color is rainbow, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isRainbow() {
		return this.spiroPen().isRainbow();
	}

	/**
	 * Answer true if the receiver contains the specified point, otherwise false.
	 * 
	 * @param aPoint java.awt.Point
	 * @return boolean
	 * @category testing
	 */
	public boolean containsPoint_(Point aPoint) {
		if (this.bounds().contains(aPoint) == false) {
			return false;
		}

		double distance = this.teraCircle().center().distance_(new Jun2dPoint(aPoint));
		if (this.isInscribe()) {
			if (distance > this.teraCircle().radius()) {
				return false;
			}
			if (distance < this.teraCircle().radius() - this.moonCircle().radius() * 2) {
				return false;
			}
		} else {
			if (distance < this.teraCircle().radius()) {
				return false;
			}
			if (distance > this.teraCircle().radius() + this.moonCircle().radius() * 2) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Apply attributes to the specified graphics.
	 * 
	 * @param graphicsContext java.awt.Graphics2D
	 * @category private
	 */
	protected void applyAttributesToGraphicsContext_(Graphics2D graphicsContext) {
		graphicsContext.setColor(Color.green);
		graphicsContext.setStroke(new BasicStroke(1, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		graphicsContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	}

	/**
	 * Answer the receiver's popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			_popupMenu = new StPopupMenu();
			_popupMenu.add(new StMenuItem($String("Animation"), $("doAnimation"), new MenuPerformer(this, "doAnimation")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem($String("Inscribe"), $("beInscribe"), new MenuPerformer(this, "beInscribe")));
			_popupMenu.add(new StMenuItem($String("Circumscribe"), $("beCircumscribe"), new MenuPerformer(this, "beCircumscribe")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StCheckBoxMenuItem($String("Rainbow"), $("toggleRainbow"), new MenuPerformer(this, "toggleRainbow")));
			_popupMenu.add(new StMenuItem($String("Choice nib"), $("choiceNib"), new MenuPerformer(this, "choiceNib")));
			_popupMenu.add(new StMenuItem($String("Spawn as image"), $("spawnAsImage"), new MenuPerformer(this, "spawnAsImage")));
		}
		return (StPopupMenu) this.updateMenuIndication_(_popupMenu);
	}
}
