package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSpiroDesignModelTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/03/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignModelTestExamples.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesignModelTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSpiroDesignModel spiroDesignModel = new JunSpiroDesignModel();
		spiroDesignModel.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunSpiroDesignModel spiroDesignModel = ExampleSpiroDesign();
		Point windowLocation = new Point(100, 150);
		Dimension windowExtent = new Dimension(250, 250 + 20);
		for (int i = 0; i < 3; i++) {
			spiroDesignModel.openIn_(new Rectangle(windowLocation, windowExtent));
			windowLocation = new Point(windowLocation.x + windowExtent.width + 8, windowLocation.y);
		}
		(new Thread() {
			public void run() {
				try {
					this.sleep(1000);
					spiroDesignModel.startAnimation();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}).start();
		return true;
	}

	/**
	 * Answer the exaple spiro design model.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignModel
	 * @category Examples
	 */
	protected static JunSpiroDesignModel ExampleSpiroDesign() {
		JunSpiroDesignModel spiroDesignModel = new JunSpiroDesignModel(JunSpiroDesignTestExamples.ExampleSpiroDesign());
		return spiroDesignModel;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSpiroDesignModelTestExamples();
	}
}
