package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSpiroDesignTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/03/28 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignTestExamples.java,v 8.10 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesignTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSpiroDesign spiroDesign = new JunSpiroDesign();
		spiroDesign.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunSpiroDesign spiroDesign = new JunSpiroDesign(Color.cyan, 3);
		spiroDesign.open();
		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunSpiroDesign spiroDesign = new JunSpiroDesign();
		spiroDesign.beCircumscribe();
		spiroDesign.open();
		return true;
	}

	/**
	 * Example4: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		final JunSpiroDesign spiroDesign = new JunSpiroDesign();
		spiroDesign.howMany_(3);
		spiroDesign.compute_(new StBlockClosure() {
			public Object value_(Object obj) {
				System.out.println(((JunSpiroDesign) obj).point().roundTo_(0.001).printString());
				return null;
			}
		});
		spiroDesign.open();
		(new Thread() {
			public void run() {
				try {
					this.sleep(1000);
					spiroDesign.doAnimation();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}).start();
		return true;
	}

	/**
	 * Example5: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		final JunSpiroDesign spiroDesign = ExampleSpiroDesign();
		Point windowLocation = new Point(100, 150);
		Dimension windowExtent = new Dimension(250, 250 + 20);
		for (int i = 0; i < 3; i++) {
			spiroDesign.openIn_(new Rectangle(windowLocation, windowExtent));
			windowLocation = new Point(windowLocation.x + windowExtent.width + 8, windowLocation.y);
		}
		(new Thread() {
			public void run() {
				try {
					this.sleep(1000);
					spiroDesign.doAnimation();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}).start();
		return true;
	}

	/**
	 * Answer the exaple spiro design.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category Examples
	 */
	protected static JunSpiroDesign ExampleSpiroDesign() {
		JunSpiroDesign spiroDesign = new JunSpiroDesign(new JunSpiroCircle(new Jun2dPoint(0, 0), 57, Color.red, 1), new JunSpiroCircle(new Jun2dPoint(86, 0), 29, Color.blue, 1), new JunSpiroPen(new Jun2dPoint(75, 18)));
		spiroDesign.beRainbowColor();
		return spiroDesign;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSpiroDesignTestExamples();
	}
}
