package jp.co.sra.jun.goodies.texteditor;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunTextEditorDialogViewSwing class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorDialogViewSwing.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextEditorDialogViewSwing extends StSimpleDialogViewSwing implements JunTextEditorDialogView {
	protected JunTextEditorViewSwing textPropertiesView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunTextEditorDialogViewSwing and initialize it.
	 * 
	 * @param aTextEditorDialog jp.co.sra.jun.goodies.texteditor.JunTextEditorDialog
	 * @category Instance creation
	 */
	public JunTextEditorDialogViewSwing(JunTextEditorDialog aTextEditorDialog) {
		super(aTextEditorDialog);
	}

	/**
	 * Answer my model as JunTextEditorDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditorDialog
	 * @see jp.co.sra.jun.goodies.texteditoreditor.JunTextEditorDialogView#getTextEditorDialog()
	 * @category model accessing
	 */
	public JunTextEditorDialog getTextEditorDialog() {
		return (JunTextEditorDialog) this.model();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		textPropertiesView = null;
		acceptButton = null;
		cancelButton = null;
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.textPropertiesView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, -1, 1f, -30));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.5f, -86, 1f, -27, 0.5f, -2, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.5f, 2, 1f, -27, 0.5f, 86, 1f, -1));
		this.setPreferredSize(new Dimension(300, 200));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer the receiver's text properties view.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditorViewSwing
	 * @category interface opening
	 */
	protected JunTextEditorViewSwing textPropertiesView() {
		if (textPropertiesView == null) {
			textPropertiesView = new JunTextEditorViewSwing(this.getTextEditorDialog().textPropertiesModel());
		}
		return textPropertiesView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 * @category interface opening
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunTextEditorDialogViewSwing.this.getTextEditorDialog().acceptButtonPressed()) {
						JunTextEditorDialogViewSwing.this.getTextEditorDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category interface opening
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunTextEditorDialogViewSwing.this.getTextEditorDialog().cancelButtonPressed()) {
						JunTextEditorDialogViewSwing.this.getTextEditorDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.textPropertiesView()._setupKeyboard(aWindow);
	}
}
