package jp.co.sra.jun.goodies.texteditor;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunTextEditorTestExamples class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextEditorTestExamples.java,v 8.11 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunTextEditorTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunTextEditor.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunTextEditor aModel = new JunTextEditor();
		aModel.open();

		return true;
	}

	/**
	 * Example2: Open a JunTextEditor with text.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunTextEditor aModel = new JunTextEditor(JunSystem.Copyright());
		aModel.open();

		return true;
	}

	/**
	 * Example3: Open a JunTextEditor with not editable mode.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunTextEditor aModel = new JunTextEditor(JunSystem.Copyright());
		aModel.beEditable(false);
		aModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunTextEditorTestExamples();
	}
}
