package jp.co.sra.jun.goodies.tools;

import java.io.File;

import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileLauncherTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2005/07/11 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun550 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileLauncherTestExamples.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public class JunFileLauncherTestExamples extends JunTestExamples {

	/**
	 * Example1: Request to select a file and launch it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		File aFile = JunFileLauncher.Request();
		return (aFile != null);
	}

	/**
	 * Example2: Request to select an image file and launch it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] { new JunFileModel.FileType("Image files", JunSystem.DefaultImageExtensionPatterns()), JunFileModel.FileType.All("All files") };
		File aFile = JunFileLauncher.Request(fileTypes);
		return (aFile != null);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunFileLauncherTestExamples();
	}

}
