package jp.co.sra.jun.goodies.utilities;

import java.io.File;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunFileUtility class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/14 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileUtility.java,v 8.8 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunFileUtility extends JunAbstractObject  {
	/**
	 * Answer the extension string of the specified file.
	 * 
	 * @param aFile java.io.File
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String ExtensionStringOf_(File aFile) {
		String aString = aFile.getPath();
		int index = aString.lastIndexOf('.');
		if (index < 0) {
			return null;
		}
		return aString.substring(index + 1).toLowerCase();
	}

}
