package jp.co.sra.jun.goodies.utilities;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageUtilityTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/04/18 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageUtilityTestExamples.java,v 8.10 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunImageUtilityTestExamples extends JunTestExamples {
	/**
	 * Example: open new window with the image from display area.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Show() {
		JunImageUtility.Show_at_(StImage._OfArea(new Rectangle(0, 0, 300, 300)), new Point(0, 0));
		return true;
	}

	/**
	 * Example: open new window with the selected image file at the file dialog.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestImage() {
		StImage anImage = JunImageUtility.RequestImage();
		if (anImage != null) {
			JunImageUtility.Show_(anImage);
		}
		return true;
	}

	/**
	 * Example: save to an image from display area. 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewImage() {
		try {
			JunImageUtility.RequestNewImageFileThenWriteImage_(StImage._OfArea(new Rectangle(0, 0, 300, 300)));
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		}
		return true;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunImageUtilityTestExamples();
	}
}
