package jp.co.sra.jun.goodies.wavelet;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDiscreteWavelet1dTransformationTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/07 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun660 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDiscreteWavelet1dTransformationTestExamples.java,v 8.6 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunDiscreteWavelet1dTransformationTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunDiscreteWavelet1dTransformation waveletTransformation = new JunDiscreteWavelet1dTransformation(JunDiscreteWavelet1dTransformationTestExamples.ExampleData());
		waveletTransformation.scalingCoefficients();
		waveletTransformation.waveletCoefficients();
		waveletTransformation.recomposedCoefficients();

		return true;
	}

	/**
	 * Example2:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDiscreteWavelet1dTransformation waveletTransformation = new JunDiscreteWavelet1dTransformation(JunDiscreteWavelet1dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(10, 100);
		double rangeValue = 2.8;
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, rangeValue, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, rangeValue, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.waveletCoefficients(), scaleFactor, rangeValue, "Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, rangeValue, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example3:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunDiscreteWavelet1dTransformation waveletTransformation = new JunDiscreteWavelet1dTransformation(JunDiscreteWavelet1dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(10, 100);
		double rangeValue = 2.8;
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, rangeValue, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));
		waveletTransformation = new JunDiscreteWavelet1dTransformation(waveletTransformation.scalingCoefficients(), waveletTransformation.waveletCoefficients());
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, rangeValue, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.waveletCoefficients(), scaleFactor, rangeValue, "Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, rangeValue, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example4:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunDiscreteWavelet1dTransformation waveletTransformation = new JunDiscreteWavelet1dTransformation(JunDiscreteWavelet1dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(10, 100);
		double rangeValue = 2.8;
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, rangeValue, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));

		double[] sourceCoefficients = waveletTransformation.sourceCoefficients();
		double[] scalingCoefficients = waveletTransformation.scalingCoefficients();
		double[] waveletCoefficients = waveletTransformation.waveletCoefficients();
		double[] absCoefficients = new double[waveletCoefficients.length];
		for (int i = 0; i < waveletCoefficients.length; i++) {
			absCoefficients[i] = Math.abs(waveletCoefficients[i]);
		}
		Arrays.sort(absCoefficients);
		for (int i = 0; i < absCoefficients.length / 2; i++) {
			double v1 = absCoefficients[i];
			double v2 = absCoefficients[absCoefficients.length - 1 - i];
			absCoefficients[i] = v2;
			absCoefficients[absCoefficients.length - 1 - i] = v1;
		}
		int highPercentage = 10;
		double thresholdValue = absCoefficients[(int) Math.round(absCoefficients.length * (highPercentage / 100.0)) - 1];
		int numberOfCoefficients = 0;
		for (int i = 0; i < waveletCoefficients.length; i++) {
			double w = waveletCoefficients[i];
			if (Math.abs(w) >= thresholdValue) {
				numberOfCoefficients = numberOfCoefficients + 1;
			} else {
				waveletCoefficients[i] = 0.0;
			}
		}

		{
			int d = sourceCoefficients.length;
			int n = scalingCoefficients.length + numberOfCoefficients;
			System.out.println("compressed " + d + " into " + n + " (" + (n / ((double) d) * 100) + "%)");
		}

		waveletTransformation = new JunDiscreteWavelet1dTransformation(scalingCoefficients, waveletCoefficients);
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, rangeValue, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.waveletCoefficients(), scaleFactor, rangeValue, "Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, rangeValue, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example: Answer the example data.
	 *  
	 * @return double[]
	 * @category Examples
	 */
	protected static double[] ExampleData() {
		double[] anArray = new double[64];
		Arrays.fill(anArray, 0.0);
		for (int i = 0; i < 16; i++) {
			anArray[i] = Math.pow((i + 1), 2) / 256;
		}
		for (int i = 16; i < 32; i++) {
			anArray[i] = 0.2;
		}
		for (int i = 32; i < 48; i++) {
			anArray[i] = Math.pow(48 - (i + 1), 2) / 256 - 0.5;
		}
		return anArray;
	}

	/**
	 * Example: Open an image display model with the specified wavelet transformation.
	 * 
	 * @param valueCollection double[]
	 * @param scaleFactor java.awt.Point
	 * @param rangeValue double
	 * @param labelString java.lang.String
	 * @param displayPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Examples
	 */
	protected static JunImageDisplayModel ExampleDisplay_scaleFactor_rangeValue_labelString_displayPoint_(double[] valueCollection, Point scaleFactor, double rangeValue, String labelString, Point displayPoint) {
		StImage aPixmap = new StImage(new Jun2dPoint(valueCollection.length, rangeValue).scaledBy_(new Jun2dPoint(scaleFactor)).rounded()._toPoint());
		Graphics2D graphicsContext = null;
		try {
			graphicsContext = (Graphics2D) aPixmap.image().getGraphics();
			graphicsContext.setColor(Color.white);
			graphicsContext.fillRect(0, 0, aPixmap.width(), aPixmap.height());
			graphicsContext.setColor(Color.gray);
			graphicsContext.setStroke(new BasicStroke(1));
			graphicsContext.drawLine(0, aPixmap.height() / 2, aPixmap.width(), aPixmap.height() / 2);
			for (int n = 0; n < valueCollection.length; n++) {
				double v = valueCollection[n];
				Jun2dPoint p = new Jun2dPoint(n, 0 - v).scaledBy_(new Jun2dPoint(scaleFactor)).plus_(new Jun2dPoint(scaleFactor.x / 2.0, aPixmap.height() / 2.0)).rounded();
				Rectangle box = new Rectangle((int) p.x(), (int) p.y(), 0, 0);
				box.grow(2, 2);
				graphicsContext.setColor(Color.black);
				graphicsContext.fill(box);
			}
		} finally {
			if (graphicsContext != null) {
				graphicsContext.dispose();
				graphicsContext = null;
			}
		}
		return JunImageDisplayModel.Show_label_at_(aPixmap, labelString, displayPoint);
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunDiscreteWavelet1dTransformationTestExamples();
	}
}
