package jp.co.sra.jun.goodies.wheels;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunThumbWheel class
 * 
 *  @author    He Weijie
 *  @created   1998/08/13 (by He Weijie)
 *  @updated   1999/12/17 (by MATSUDA Ryouichi)
 *  @updated   2004/09/22 (by nisinaka)
 *  @updated   2007/03/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunThumbWheel.java,v 8.12 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunThumbWheel extends JunApplicationModel {
	/** A boolean value as a button model. */
	protected StValueHolder angularValue;
	protected boolean verticalFlag;

	/**
	 * Create a new instance of <code>JunThumbWheel</code> with horizontal.
	 * 
	 * @return jp.co.sra.jun.goodies.wheels.JunThumbWheel
	 * @category Instance creation
	 */
	public static JunThumbWheel Horizontal() {
		JunThumbWheel aModel = new JunThumbWheel();
		aModel.verticalFlag_(false);
		return aModel;
	}

	/**
	 * Create a new instance of <code>JunThumbWheel</code> with vertical.
	 * 
	 * @return jp.co.sra.jun.goodies.wheels.JunThumbWheel
	 * @category Instance creation
	 */
	public static JunThumbWheel Vertical() {
		JunThumbWheel aModel = new JunThumbWheel();
		aModel.verticalFlag_(true);
		return aModel;
	}

	/**
	 * Create a new instance of <code>JunThumbWheel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunThumbWheel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunThumbWheel</code> and initialize it.
	 * 
	 * @param isVertical boolean
	 * @category Instance creation
	 */
	public JunThumbWheel(boolean isVertical) {
		super();
		this.verticalFlag_(isVertical);
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		angularValue = new StValueHolder(0.0);
		verticalFlag = false;
		this.compute_(new StBlockClosure() {
			public Object value() {
				JunThumbWheel self = JunThumbWheel.this;
				self.changed_with_($("value"), new Double(self.angularValue()));
				return null;
			}
		});
	}

	/**
	 * Just return the current angularValue.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double angularValue() {
		return ((Number) angularValue.value()).doubleValue();
	}

	/**
	 * Set the new angularValue.
	 * 
	 * @param aValue double
	 * @category accessing
	 */
	public void angularValue_(double aValue) {
		angularValue.value_(new Double(aValue));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category accessing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return new StBlockValue(aBlock, angularValue);
	}

	/**
	 * Answer the receiver's vertical flag.
	 * 
	 * @return boolean
	 * @category accessing
	 */
	public boolean verticalFlag() {
		return verticalFlag;
	}

	/**
	 * Set the receiver's vertical flag.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void verticalFlag_(boolean aBoolean) {
		verticalFlag = aBoolean;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunThumbWheelViewAwt(this);
		} else {
			return new JunThumbWheelViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Thumb Wheel");
	}

	/**
	 * Print my string representation on aWriter.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);
		aWriter.write(" on: ");
		aWriter.write(String.valueOf(this.angularValue()));
	}
}
