package jp.co.sra.jun.goodies.wheels;

import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunThumbWheelTestExamples class
 * 
 *  @author    He Weijie
 *  @created   1998/10/26 (by He Weijie)
 *  @updated   2007/03/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunThumbWheelTestExamples.java,v 8.12 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunThumbWheelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Examples:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunThumbWheel thumbWheel = JunThumbWheel.Horizontal();
		thumbWheel.openAt_(new Point(100, 100));
		thumbWheel.openAt_(new Point(300, 100));

		return true;
	}

	/**
	 * Examples:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunThumbWheel thumbWheel = JunThumbWheel.Vertical();
		thumbWheel.openAt_(new Point(100, 100));
		thumbWheel.openAt_(new Point(300, 100));

		return true;
	}

	/**
	 * Examples:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunThumbWheel thumbWheel = JunThumbWheel.Horizontal();
		thumbWheel.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		thumbWheel.open();

		return true;
	}

	/**
	 * Examples:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunThumbWheel thumbWheel = JunThumbWheel.Vertical();
		thumbWheel.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value);
				return null;
			}
		});
		thumbWheel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunThumbWheelTestExamples();
	}
}
