package jp.co.sra.jun.graphics.abstracts;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StValueHolder;

/**
 * JunAbstractMap class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/15 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractMap.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunAbstractMap extends JunAbstractVisual {
	protected ArrayList componentItems = null;
	protected Rectangle preferredBounds = null;

	/**
	 * Added the component item.
	 * 
	 * @param anItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category adding
	 */
	public void add_(JunAbstractItem anItem) {
		if (this.componentItems().contains(anItem)) {
			return;
		}
		if (this.componentItems().add(anItem));
		this.flushBounds();
	}

	/**
	 * Arrange the positions of all items.
	 * 
	 * @category arranging
	 */
	public void arrange() {
		// no oparation
		return;
	}

	/**
	 * Answer the item at the specified position in this components.
	 * 
	 * @param anIndex int
	 * @return jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category accessing
	 */
	public JunAbstractItem componentItemAt_(int anIndex) {
		if (0 <= anIndex && anIndex < this.componentItems().size()) {
			return (JunAbstractItem) this.componentItems().get(anIndex);
		}
		return null;
	}

	/**
	 * Answer the array list of components items.
	 * 
	 * @return java.util.ArrayList
	 * @category accessing
	 */
	public ArrayList componentItems() {
		if (componentItems == null) {
			componentItems = new ArrayList();
		}
		return componentItems;
	}

	/**
	 * Set the array list of component items.
	 * 
	 * @param aCollection java.util.ArrayList
	 * @category accessing
	 */
	public void componentItems_(ArrayList aCollection) {
		componentItems = aCollection;
	}

	/**
	 * Display the receiver's items on the graphics.
	 * 
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(final Graphics aGraphics) {
		this.itemsDo_(new StBlockClosure() {
			public Object value_(Object o) {
				JunAbstractItem item = (JunAbstractItem) o;
				item.displayOn_(aGraphics);
				return null;
			}
		});
	}

	/**
	 * Flush the receiver's preferred bounds.
	 * 
	 * @category flushing
	 */
	public void flushBounds() {
		preferredBounds = null;
	}

	/**
	 * Answer true if the receiver is empty, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmpty() {
		return this.componentItems().isEmpty();
	}

	/**
	 * Answer true if the receiver is map, otherwise false.
	 * 
	 * @see jp.co.sra.jun.graphics.abstracts.JunAbstractVisual#isMap()
	 * @category testing
	 */
	public boolean isMap() {
		return true;
	}

	/**
	 * Enumerate all items and evaluate the block.
	 * 
	 * @see jp.co.sra.jun.graphics.Abstract.JunAbstractVisual#itemsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public Object itemsDo_(StBlockClosure aBlock) {
		for (int i = 0; i < this.componentItems().size(); i++) {
			Object o = aBlock.value_(this.componentItems().get(i));
			if (o != null) {
				return o;
			}
		}
		return null;
	}

	/**
	 * Answer the preferred bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle preferredBounds() {
		if (preferredBounds == null) {
			final StValueHolder aBox = new StValueHolder(new StRectangle(0, 0, 0, 0));
			this.itemsDo_(new StBlockClosure() {
				public Object value_(Object o) {
					JunAbstractItem item = (JunAbstractItem) o;
					StRectangle _aBox = (StRectangle) aBox.value();
					aBox.value_(new StRectangle(item.bounds()).merge_(_aBox));
					return null;
				}
			});
			preferredBounds = ((StRectangle) aBox.value()).toRectangle();
		}
		return preferredBounds;
	}

	/**
	 * Remove the specified item from the receiver.
	 * 
	 * @param anItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @return jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category removing
	 */
	public JunAbstractItem remove_(JunAbstractItem anItem) {
		int index = this.componentItems().indexOf(anItem);
		if (index < 0) {
			return null;
		}
		this.componentItems().remove(index);
		this.flushBounds();
		return anItem;
	}

	/**
	 * Remove the specified item with the index from the receiver.
	 * 
	 * @param anIndex int
	 * @return jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category removing
	 */
	public JunAbstractItem removeIndex_(int anIndex) {
		JunAbstractItem removeItem = (JunAbstractItem) this.componentItems().remove(anIndex);
		this.flushBounds();
		return removeItem;
	}

	/**
	 * Enumerate all items as reverse order and evaluate the block.
	 * 
	 * @see jp.co.sra.jun.graphics.Abstract.JunAbstractVisual#itemsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public Object reverseItemsDo_(StBlockClosure aBlock) {
		for (int i = this.componentItems().size() - 1; 0 <= i; i--) {
			Object o = aBlock.value_(this.componentItems().get(i));
			if (o != null) {
				return o;
			}
		}
		return null;
	}
}
