package jp.co.sra.jun.graphics.framework;

import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunGraphicView interface
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/11 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun640 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGraphicView.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public interface JunGraphicView extends JunAbstractView {
	/**
	 * Answer the receiver's bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle getBounds();

	/**
	 * Answer the receiver's model as <code>JunGraphicModel</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.framework.JunGraphModel
	 * @category accessing
	 */
	public JunGraphicModel getGraphicModel();

	/**
	 * Make the specified rectangle area visible.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @category scrolling
	 */
	public void makeVisible(Rectangle aRectangle);

	/**
	 * Answer the receiver's current scroll offset.
	 * 
	 * @return java.awt.Point
	 * @category scrolling
	 */
	public Point scrollOffset();

	/**
	 * Position the view to a particular place, updating the display.
	 * 
	 * @param aPoint java.awt.Point
	 * @category scrolling
	 */
	public void scrollTo_(Point aPoint);
}
