package jp.co.sra.jun.graphics.list;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StViewJPanel;

import jp.co.sra.jun.graphics.framework.JunGraphicController;
import jp.co.sra.jun.graphics.framework.JunGraphicViewSwing;

/**
 * JunSequenceListViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2004/01/21 (by nisinaka)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSequenceListViewSwing.java,v 8.11 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunSequenceListViewSwing extends JunGraphicViewSwing implements JunSequenceListView {
	/**
	 * Create a new instance of <code>JunSequenceListViewSwing</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.graphics.list.JunSequenceList
	 * @category Instance creation
	 */
	public JunSequenceListViewSwing(JunSequenceList aModel) {
		super(aModel);
	}

	/**
	 * Answer the receiver's model as <code>JunSequenceList</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.list.JunSequenceList
	 * @see jp.co.sra.jun.graphics.list.JunSequenceListView#getSequenceList()
	 * @category accessing
	 */
	public JunSequenceList getSequenceList() {
		return (JunSequenceList) this.model();
	}

	/**
	 * Answer the graphic view.
	 * 
	 * @return jp.co.sra.smalltalk.StViewJPanel
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewSwing#canvas()
	 * @category user interface
	 */
	public StViewJPanel canvas() {
		if (canvas == null) {
			canvas = new StViewJPanel(this.getGraphicModel()) {
				/**
				 * Answer the receiver's default controller
				 * 
				 * @return jp.co.sra.smalltalk.StController
				 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
				 * @category controller accessing
				 */
				protected StController defaultController() {
					return new JunGraphicController();
				}

				/**
				 * Display the receiver on the graphics.
				 * 
				 * @param aGraphics java.awt.Graphics
				 * @see jp.co.sra.smalltalk.StViewJPanel#displayOn_(java.awt.Graphics)
				 * @category displaying
				 */
				public void displayOn_(Graphics aGraphics) {
					JunSequenceListViewSwing.this.displayCanvasOn_(aGraphics);
				}

				/**
				 * Update the receiver according to the change notification from the model.
				 * 
				 * @param evt jp.co.sra.smalltalk.DependentEvent
				 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
				 * @category updating
				 */
				public void update_(DependentEvent evt) {
					if (evt.getAspect() == $("redisplay")) {
						this.popupMenu_(null);
					}

					super.update_(evt);
				}
			};
			canvas.setBackground(Color.white);
		}

		return canvas;
	}

	/**
	 * Answer the scroll pane which doesn't have a horizontal scrollbar.
	 * 
	 * @return javax.swing.JScrollPane
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewSwing#scrollPane()
	 * @category user interface
	 */
	protected JScrollPane scrollPane() {
		if (scrollPane == null) {
			scrollPane = super.scrollPane();
			scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		}
		return scrollPane;
	}

	/**
	 * Update the canvas size.
	 * 
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewSwing#updateCanvasSize()
	 * @category updating
	 */
	protected void updateCanvasSize() {
		super.updateCanvasSize();

		Dimension viewportSize = this.scrollPane().getViewport().getSize();
		Dimension scrollableSize = this.scrollPane().getViewport().getViewSize();
		int itemSize = this.getSequenceList().sequenceMap().componentItems().size();
		int unitHeight = (itemSize > 0 && scrollableSize.height > viewportSize.height) ? Math.max(1, scrollableSize.height / itemSize) : 1;
		JScrollBar verticalScrollBar = this.scrollPane().getVerticalScrollBar();
		verticalScrollBar.setUnitIncrement(unitHeight);
	}
}
