package jp.co.sra.jun.graphics.map;

import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.graphics.abstracts.JunAbstractMap;

/**
 * JunSequenceMap class
 * 
 *  @author    nisinaka
 *  @created   2004/01/09 (by nisinaka)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSequenceMap.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunSequenceMap extends JunAbstractMap {
	/**
	 * Add a new item before the existing another item.
	 * 
	 * @param anItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @param anotherItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @category adding
	 */
	public void add_before_(JunAbstractItem anItem, JunAbstractItem anotherItem) {
		if (anotherItem == null) {
			this.componentItems().add(anItem);
		} else {
			this.add_beforeIndex_(anItem, this.componentItems().indexOf(anotherItem));
		}
		this.flushBounds();
	}

	/**
	 * Add a new item before the index.
	 * 
	 * @param anItem jp.co.sra.jun.graphics.abstracts.JunAbstractItem
	 * @param anIndex int
	 * @category adding
	 */
	public void add_beforeIndex_(JunAbstractItem anItem, int anIndex) {
		if (0 <= anIndex && anIndex < this.componentItems().size()) {
			this.componentItems().add(anIndex, anItem);
		} else {
			this.componentItems().add(anItem);
		}
		this.flushBounds();
	}

	/**
	 * Arrange the positions of all items.
	 * 
	 * @see jp.co.sra.jun.graphics.abstracts.JunAbstractMap#arrange()
	 * @category arranging
	 */
	public void arrange() {
		final Point aPoint = new Point(0, 0);
		this.itemsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunAbstractItem item = (JunAbstractItem) anObject;
				item.originPoint_(new Point(aPoint));
				aPoint.y += item.bounds().height;
				return null;
			}
		});
		this.flushBounds();
	}

	/**
	 * Answer whether the receiver is a kind of sequence or not.
	 * 
	 * @see jp.co.sra.jun.graphics.abstracts.JunAbstractVisual#isSequence()
	 * @category testing
	 */
	public boolean isSequence() {
		return true;
	}
}
