package jp.co.sra.jun.graphics.map;

import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.graphics.item.JunCompositeItem;
import jp.co.sra.jun.graphics.item.JunCompositeItemTestExamples;
import jp.co.sra.jun.graphics.item.JunPrimitiveItem;
import jp.co.sra.jun.graphics.item.JunPrimitiveItemTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSequenceMapTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/09 (by nisinaka)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSequenceMapTestExamples.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunSequenceMapTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		aMap.add_before_(anIconItem, aMap.componentItemAt_(4));
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(0);
				return null;
			}
		});
		aMap.arrange();

		JunDisplayModel aDisplayModel = new JunDisplayModel(aMap);
		aDisplayModel.openIn_(new Rectangle(200, 200, 300, 300));

		return true;
	}

	/**
	 * Example2:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		aMap.add_beforeIndex_(anIconItem, 4);
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(0);
				return null;
			}
		});
		aMap.arrange();

		JunDisplayModel aDisplayModel = new JunDisplayModel(aMap);
		aDisplayModel.openIn_(new Rectangle(200, 200, 300, 300));

		return true;
	}

	/**
	 * Example3:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		aMap.add_beforeIndex_(anIconItem, 4);
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(0);
				return null;
			}
		});
		aMap.remove_((JunAbstractItem) aMap.componentItems().get(2));
		aMap.arrange();

		JunDisplayModel aDisplayModel = new JunDisplayModel(aMap);
		aDisplayModel.openIn_(new Rectangle(200, 200, 300, 300));

		return true;
	}

	/**
	 * Example4:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		aMap.add_beforeIndex_(anIconItem, 4);
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(0);
				return null;
			}
		});
		aMap.removeIndex_(2);
		aMap.arrange();

		JunDisplayModel aDisplayModel = new JunDisplayModel(aMap);
		aDisplayModel.openIn_(new Rectangle(200, 200, 300, 300));

		return true;
	}

	/**
	 * Example5:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		aMap.allItemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(1);
				return null;
			}
		});
		aMap.itemsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunCompositeItem item = (JunCompositeItem) anObject;
				item.extentPoint_(new Point(100, item.bounds().height));
				item.arrange_alignment_(item.itemAt_(2), $("rightCenter"));
				item.arrange_in_(item.itemAt_(1), StRectangle.Origin_corner_((new StRectangle(item.itemAt_(0).bounds())).topRight(), (new StRectangle(item.itemAt_(2).bounds())).bottomLeft()).toRectangle());
				return null;
			}
		});
		aMap.arrange();

		JunDisplayModel aDisplayModel = new JunDisplayModel(aMap);
		aDisplayModel.openIn_(new Rectangle(200, 200, 300, 300));

		return true;
	}

	/**
	 * Create an example map.
	 * 
	 * @return jp.co.sra.jun.graphics.map.JunSequenceMap
	 * @category Examples
	 */
	public static JunSequenceMap _ExampleMap() {
		JunSequenceMap aMap = new JunSequenceMap();
		for (int i = 0; i < 7; i++) {
			JunCompositeItem aCompositeItem = JunCompositeItemTestExamples.ExampleCompositeItem();
			aMap.add_(aCompositeItem);
		}
		aMap.allItemsDo_(new StBlockClosure() {
			public Object value_(Object item) {
				((JunAbstractItem) item).borderWidth_(0);
				return null;
			}
		});
		aMap.arrange();
		return aMap;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSequenceMapTestExamples();
	}
}
