package jp.co.sra.jun.graphics.navigator;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import javax.swing.KeyStroke;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.graphics.abstracts.JunAbstractVisual;
import jp.co.sra.jun.graphics.abstracts.JunAbstractItem.LookPreferences;

/**
 * JunEmbeddedCenterFileList class
 * 
 *  @author    nisinaka
 *  @created   2004/01/22 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEmbeddedCenterFileList.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunEmbeddedCenterFileList extends JunEmbeddedFileList {
	/**
	 * Answer my current look preferences.
	 * 
	 * @return jp.co.sra.jun.graphics.graphics.abstracts.JunAbstractItem.LookPreferences
	 * @see jp.co.sra.jun.graphics.list.JunFileList#lookPreferences()
	 * @category visual properties
	 */
	public LookPreferences lookPreferences() {
		if (lookPreferences == null) {
			lookPreferences = new LookPreferences();
			lookPreferences.setForegroundColor(JunAbstractVisual.ForegroundColor());
			lookPreferences.setBackgroundColor(JunAbstractVisual.BackgroundColor());
			lookPreferences.setSelectionForegroundColor(Color.white);
			lookPreferences.setSelectionBackgroundColor(Color.getHSBColor(0.62f, 0.91f, 0.42f));
		}
		return lookPreferences;
	}

	/**
	 * Create the key stroke dispatch table.
	 * 
	 * @return java.util.Map
	 * @see jp.co.sra.jun.graphics.navigator.JunEmbeddedFileList#createKeyStrokeDispatchTable()
	 * @category keyboard
	 */
	protected Map createKeyStrokeDispatchTable() {
		HashMap aMap = new HashMap();
		aMap.put(KeyStroke.getKeyStroke("ENTER"), new StBlockClosure() {
			public Object value() {
				keyStrokePressENTER();
				return null;
			}
		});
		aMap.put(KeyStroke.getKeyStroke("SPACE"), new StBlockClosure() {
			public Object value() {
				keyStrokePressSPACE();
				return null;
			}
		});
		aMap.put(KeyStroke.getKeyStroke("LEFT"), new StBlockClosure() {
			public Object value() {
				keyStrokePressLEFT();
				return null;
			}
		});
		aMap.put(KeyStroke.getKeyStroke("RIGHT"), new StBlockClosure() {
			public Object value() {
				keyStrokePressRIGHT();
				return null;
			}
		});
		aMap.put(KeyStroke.getKeyStroke("UP"), new StBlockClosure() {
			public Object value() {
				keyStrokePressUP();
				return null;
			}
		});
		aMap.put(KeyStroke.getKeyStroke("DOWN"), new StBlockClosure() {
			public Object value() {
				keyStrokePressDOWN();
				return null;
			}
		});
		return aMap;
	}

	/**
	 * Handle the key stroke ENTER.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressENTER()
	 * @category keyboard
	 */
	protected boolean keyStrokePressENTER() {
		super.keyStrokePressENTER();

		JunFileNavigator navigator = this.fileNavigator();
		if (navigator != null) {
			JunEmbeddedRightFileList rightList = navigator.rightList();
			if (rightList.isFile()) {
				navigator.rightFileItemPressed_(rightList.currentFile());
			}
		}

		return true;
	}

	/**
	 * Handle the key stroke SPACE.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressSPACE()
	 * @category keyboard
	 */
	protected boolean keyStrokePressSPACE() {
		// Do nothing
		return true;
	}

	/**
	 * Handle the key stroke LEFT.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressLEFT()
	 * @category keyboard
	 */
	protected boolean keyStrokePressLEFT() {
		if (super.keyStrokePressLEFT()) {
			JunFileNavigator navigator = this.fileNavigator();
			if (navigator != null && navigator.centerList().isNull() == false) {
				if (navigator.leftList().isNull() && navigator.centerList().isRoot()) {
					navigator.leftNullItemPressed_(null);
					navigator.fixScrollingOffset();
				} else {
					navigator.leftDirectoryItemPressed_(navigator.leftList().selectedFile());
					navigator.fixScrollingOffset();
				}
			}
		}

		return true;
	}

	/**
	 * Handle the key stroke RIGHT.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressRIGHT()
	 * @category keyboard
	 */
	protected boolean keyStrokePressRIGHT() {
		if (super.keyStrokePressRIGHT()) {
			JunFileNavigator navigator = this.fileNavigator();
			if (navigator != null) {
				JunEmbeddedRightFileList rightList = navigator.rightList();
				if (rightList.selectedFile() == null) {
					if (rightList.isEmpty() == false) {
						if (rightList.isFile()) {
							navigator.rightFileItemPressed_(rightList.currentFile());
						} else {
							navigator.rightDirectoryItemPressed_(rightList.fileAt_(0));
							navigator.fixScrollingOffset();
						}
					}
				} else {
					navigator.rightDirectoryItemPressed_(rightList.selectedFile());
					navigator.fixScrollingOffset();
				}
			}
		}

		return true;
	}

	/**
	 * Handle the key stroke UP.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressUP()
	 * @category keyboard
	 */
	protected boolean keyStrokePressUP() {
		if (super.keyStrokePressUP()) {
			JunFileNavigator navigator = this.fileNavigator();
			if (navigator != null && navigator.centerList().isNull() == false) {
				JunEmbeddedCenterFileList centerList = navigator.centerList();
				navigator.centerDirectoryItemPressed_(centerList.selectedFile());
			}
		}

		return true;
	}

	/**
	 * Handle the key stroke DOWN.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.graphics.list.JunFileList#keyStrokePressDOWN()
	 * @category keyboard
	 */
	protected boolean keyStrokePressDOWN() {
		if (super.keyStrokePressDOWN()) {
			JunFileNavigator navigator = this.fileNavigator();
			if (navigator != null && navigator.centerList().isNull() == false) {
				JunEmbeddedCenterFileList centerList = navigator.centerList();
				navigator.centerDirectoryItemPressed_(centerList.selectedFile());
			}
		}

		return true;
	}
}
