package jp.co.sra.jun.graphics.navigator;

import java.io.File;
import jp.co.sra.jun.goodies.files.JunFileModel.FileType;

import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialogTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileRequesterDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/04/12 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileRequesterDialogTestExamples.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileRequesterDialogTestExamples extends JunTestExamples {
	/**
	 * Example: Open a new file requester.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunFileRequesterDialog fileRequesterDialog = new JunFileRequesterDialog();
		fileRequesterDialog.openDialog();
		return true;
	}

	/**
	 * Example_Request: Open a file requester dialog to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Request() {
		File aFile = JunFileRequesterDialog.Request();
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_Request_: Open a file requester dialog with the specified message string to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Request_() {
		File aFile = JunFileRequesterDialog.Request($String("Select a file."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_Request_fileTypes_initialFileType__: Open a file requester dialog with the specified message string and others to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Request_fileTypes_initialFileType_() {
		FileType[] fileTypes = new FileType[] { new FileType($String("<1p> files", "Java files", "Java"), new String[] { "*.java", "*.JAVA" }), FileType.All($String("All files")) };
		File aFile = JunFileRequesterDialog.Request($String("Select a <1p> file.", "Select a Java file.", "Java"), fileTypes, fileTypes[0]);
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_Request_initialDirectory_initialFile_fileTypes_initialFileType_onAccept_onCancel_: Open a file requester dialog with the specified message string to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Request_initialDirectory_initialFile_fileTypes_initialFileType_onAccept_onCancel_() {
		File aFile = JunFileRequesterDialog.Request(null, new File("c:\\"), new File("autoexec.bat"), null, null, null, null);
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestDirectory_: Open a file requester dialog with the specified message string to request a directory.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestDirectory_() {
		File aFile = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestDirectory_initialFile__: Open a file requester dialog with the specified message string and others to request a directory.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestDirectory_initialFile_() {
		File aFile = JunFileRequesterDialog.RequestDirectory($String("Select a directory."), new File("."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestFile__: Open a file requester dialog with the specified message string to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestFile_() {
		File aFile = JunFileRequesterDialog.RequestFile($String("Select a file."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestFile_fileTypes_initialFileType___: Open a file requester dialog with the specified message string and others to request a file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestFile_fileTypes_initialFileType_() {
		FileType[] fileTypes = new FileType[] { new FileType($String("<1p> files", "Java files", "Java"), new String[] { "*.java", "*.JAVA" }), FileType.All($String("All files")) };
		File aFile = JunFileRequesterDialog.RequestFile($String("Select a <1p> file.", "Select a Java file.", "Java"), fileTypes, fileTypes[0]);
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewDirectory_: Open a file requester dialog with the specified message string to request a new directory.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewDirectory_() {
		File aFile = JunFileRequesterDialog.RequestNewDirectory($String("Input a directory."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewDirectory_: Open a file requester dialog with the specified message string and others to request a new directory.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewDirectory_initialDirectory_() {
		File aFile = JunFileRequesterDialog.RequestNewDirectory($String("Input a directory."), new File("Jun999"));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewFile_: Open a file requester dialog with the specified message string to request a new file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewFile_() {
		File aFile = JunFileRequesterDialog.RequestNewFile($String("Input a file."));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewFile_fileTypes_initialFileType_: Open a file requester dialog with the specified message string and others to request a new file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewFile_fileTypes_initialFileType_() {
		FileType[] fileTypes = new FileType[] { new FileType($String("<1p> files", "Java files", "Java"), new String[] { "*.java", "*.JAVA" }), new FileType($String("Text files"), new String[] { "*.txt", "*.TXT" }), FileType.All($String("All files")) };
		File aFile = JunFileRequesterDialog.RequestNewFile($String("Input a file."), null, fileTypes, fileTypes[0]);
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewFile_initialFile_: Open a file requester dialog with the specified message string and others to request a new file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewFile_initialFile_() {
		File aFile = JunFileRequesterDialog.RequestNewFile($String("Input a file."), new File("zzz.txt"));
		System.out.println(aFile);
		return true;
	}

	/**
	 * Example_RequestNewFile_initialFile_fileTypes_initialFileType_: Open a file requester dialog with the specified message string and others to request a new file.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_RequestNewFile_initialFile_fileTypes_initialFileType_() {
		FileType[] fileTypes = new FileType[] { new FileType($String("<1p> files", "Java files", "Java"), new String[] { "*.java", "*.JAVA" }), new FileType($String("Text files"), new String[] { "*.txt", "*.TXT" }), FileType.All($String("All files")) };
		File aFile = JunFileRequesterDialog.RequestNewFile($String("Input a file."), new File("zzz.txt"), fileTypes, fileTypes[0]);
		System.out.println(aFile);
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunFileRequesterDialogTestExamples();
	}
}
