package jp.co.sra.jun.graphics.navigator;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.movie.framework.JunMovieViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewSwing;
import jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunMultiMediaNavigatorViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2004/02/09 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @updated   2007/03/14 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun656 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaNavigatorViewSwing.java,v 8.12 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMultiMediaNavigatorViewSwing extends JunAbstractViewJPanel implements JunMultiMediaNavigatorView {
	protected JSplitPane splitView;
	protected JunFileNavigatorViewSwing fileView;
	protected JunMultiMediaTextViewSwing textView;
	protected JunMultiMediaImageViewSwing imageView;
	protected JunMultiMediaMovieViewSwing movieView;
	protected JunMultiMediaBodyViewSwing bodyView;

	/**
	 * Create a new instance of <code>JunMultiMediaNavigatorViewSwing</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigator
	 * @category Instance creation
	 */
	public JunMultiMediaNavigatorViewSwing(JunMultiMediaNavigator aModel) {
		super(aModel);
	}

	/**
	 * Answer the receiver's model as <code>JunMultiMediaNavigator</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigator
	 * @see jp.co.sra.jun.graphics.navigator.JunMultiMediaNavigatorView#getMultiMediaNavigator()
	 * @category accessing
	 */
	public JunMultiMediaNavigator getMultiMediaNavigator() {
		return (JunMultiMediaNavigator) this.model();
	}

	/**
	 * Moves and resizes this component.
	 * 
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 * @category bounds accessing
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);

		if (height < 300) {
			this.splitView().setDividerLocation(0.5);
			this.splitView().resetToPreferredSizes();
		}
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewAwt#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		splitView = null;
		fileView = null;
		textView = null;
		imageView = null;
		movieView = null;
		bodyView = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		JSplitPane splitView = this.splitView();
		splitView.setTopComponent(this.multiMediaView());
		splitView.setBottomComponent(this.fileView());
		splitView.setDividerLocation(313);

		this.setLayout(new WindowSpecLayout());
		this.add(splitView, WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		this.setPreferredSize(new Dimension(500, 600));
	}

	/**
	 * Answer my split pane view.
	 *
	 * @return javax.swing.JSplitPane
	 * @category user interface
	 */
	public JSplitPane splitView() {
		if (splitView == null) {
			splitView = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true);
			splitView.setOneTouchExpandable(false);
			splitView.setResizeWeight(1.0);
		}
		return splitView;
	}

	/**
	 * Answer my multimedia view.
	 * 
	 * @return javax.swing.JPanel
	 * @category user interface
	 */
	public JPanel multiMediaView() {
		JPanel multiMediaView = new JPanel();
		multiMediaView.setLayout(new WindowSpecLayout());
		multiMediaView.setMinimumSize(new Dimension(200, 300));
		multiMediaView.add(this.textView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		multiMediaView.add(this.imageView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		multiMediaView.add(this.movieView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		multiMediaView.add(this.bodyView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));
		return multiMediaView;
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.graphics.navigator.JunFileNavigatorViewSwing
	 * @category user interface
	 */
	public JunFileNavigatorViewSwing fileView() {
		if (fileView == null) {
			fileView = new JunFileNavigatorViewSwing(this.getMultiMediaNavigator().fileModel());
			fileView.setMinimumSize(new Dimension(200, 100));
		}
		return fileView;
	}

	/**
	 * Answer my text view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaTextViewSwing
	 * @category user interface
	 */
	public JunMultiMediaTextViewSwing textView() {
		if (textView == null) {
			textView = new JunMultiMediaTextViewSwing(this.getMultiMediaNavigator().textModel());
			textView.setVisible(false);
		}
		return textView;
	}

	/**
	 * Answer my image view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaImageViewSwing
	 * @category user interface
	 */
	public JunMultiMediaImageViewSwing imageView() {
		if (imageView == null) {
			imageView = new JunMultiMediaImageViewSwing(this.getMultiMediaNavigator().imageModel());
			imageView.setVisible(false);
		}
		return imageView;
	}

	/**
	 * Answer my movie view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieViewSwing
	 * @category user interface
	 */
	public JunMultiMediaMovieViewSwing movieView() {
		if (movieView == null) {
			movieView = new JunMultiMediaMovieViewSwing(this.getMultiMediaNavigator().movieModel());
			movieView.setVisible(false);
		}
		return movieView;
	}
	
	/**
	 * Make sure to have both a model and a controller before showing.
	 * 
	 * For JDK1.4, because a bodyView is displayed with white.
	 * 
	 * @see java.awt.Component#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();
		this.bodyView().setVisible(false);
	}

	/**
	 * Answer my body view.
	 *
	 * @return jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyViewSwing
	 * @category user interface
	 */
	public JunMultiMediaBodyViewSwing bodyView() {
		if (bodyView == null) {
			bodyView = new JunMultiMediaBodyViewSwing(this.getMultiMediaNavigator().bodyModel());
			bodyView.setVisible(true);
		}
		return bodyView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		super._setupKeyboard(aWindow);

		KeyListener keyListener = this.movieView().getMoviePlayer()._keyListener();
		if (keyListener == null) {
			return;
		}

		final JunMovieViewSwing moviePlayerView = this.movieView().movieView();
		moviePlayerView.addKeyListener(keyListener);
		moviePlayerView.addMouseListener(new MouseAdapter() {
			public void mouseEntered(MouseEvent e) {
				if (aWindow.isActive() && aWindow.getFocusOwner() != moviePlayerView) {
					moviePlayerView.requestFocus();
				}
			}
		});
	}
}
