package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.abstracts.*;

/**
 * JunMetaSphere class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaSphere.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMetaSphere extends JunDistanceMetaball {
	/** center. */
	protected Jun3dPoint center;

	/**
	 * Create a new instance of JunDistanceMetaball and initialize it.
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaSphere
	 */
	JunMetaSphere() {
		super();
	}

	/**
	 * Create a new instance of JunMetaSphere and set it with center.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaSphere
	 */
	public static JunMetaSphere Center_(Jun3dPoint aJun3dPoint) {
		JunMetaSphere metaSphere = new JunMetaSphere();
		metaSphere.center_(aJun3dPoint);

		return metaSphere;
	}

	/**
	 * Create a new instance of JunMetaSphere and set it with center, order and
	 * weight.
	 * 
	 * @param aJun3dPoint
	 * @param aNumber1
	 * @param aNumber2
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaSphere
	 */
	public static JunMetaSphere Center_order_weight_(Jun3dPoint aJun3dPoint, int aNumber1, double aNumber2) {
		JunMetaSphere metaSphere = new JunMetaSphere();
		metaSphere.order_(aNumber1);
		metaSphere.weight_(aNumber2);
		metaSphere.center_(aJun3dPoint);

		return metaSphere;
	}

	/**
	 * anser the center.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint center() {
		return this.center;
	}

	/**
	 * set the center.
	 * 
	 * @param aJun3dPoint
	 */
	public void center_(Jun3dPoint aJun3dPoint) {
		this.center = aJun3dPoint;
	}

	/**
	 * Answer a value of the distance.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double distance_(Jun3dPoint aJun3dPoint) {
		return this.center.distance_(aJun3dPoint);
	}
}
