package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Rectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunChartPlotWithNumericalKeysTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartPlotWithNumericalKeysTestExamples.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartPlotWithNumericalKeysTestExamples extends JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataWithNumericalKeysTestExamples.SampleSamples());
		aChart.open();

		return true;
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataWithNumericalKeysTestExamples.SampleSamples());
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataWithNumericalKeysTestExamples.SampleSamples());
		aChart.pointSize_(0.05);
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataTestExamples.SampleSamples2());
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataTestExamples.SampleSamples2());
		aChart.valueRangeFrom_to_(0, 350);
		aChart.keyRangeFrom_to_(0.5, 4.5);
		aChart.colors_(new Color[] { new Color(255, 127, 0), new Color(127, 63, 63) });
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataTestExamples.SampleSamples2());
		aChart.valueRangeFrom_to_(0, 350);
		aChart.keyRangeFrom_to_(0.5, 4.5);
		aChart.colors_(new Color[] { new Color(255, 127, 0), new Color(127, 63, 63) });
		aChart.axisColor_(Color.red);
		aChart.labelForegroundColor_(Color.red);
		aChart.labelBackgroundColor_(Color.green);
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();
		aChart.open();

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunChartPlotWithNumericalKeys aChart = new JunChartPlotWithNumericalKeys(JunChartDataTestExamples.SampleSamples2());
		aChart.pointSize_(0.025);
		aChart.valueRangeFrom_to_(0, 350);
		aChart.keyRangeFrom_to_(0.5, 4.5);
		aChart.colors_(new Color[] { new Color(255, 127, 0), new Color(127, 63, 63) });
		aChart.axisColor_(Color.red);
		aChart.labelForegroundColor_(Color.blue);
		aChart.labelBackgroundColor_(Color.green);
		aChart.labelHeight_(0.1);
		aChart.useScalableLabels();
		aChart.showXAxisWithLabels();
		aChart.showYAxisWithLabels();

		JunOpenGL3dObject extraObject = JunOpenGL3dObject.SmalltalkPlane().scaledBy_(2).translatedBy_(new Jun3dPoint(-0.5, -0.5, -0.1));
		extraObject.halftone_(0.5);
		aChart.extra3dObjects_(new JunOpenGL3dObject[] { extraObject });
		aChart.openIn_(new Rectangle(150, 150, 600, 600));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunChartPlotWithNumericalKeysTestExamples();
	}

}
