package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Rectangle;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dTransformedObject;

/**
 * JunOpenGLDisplayLightTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2003/05/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun608 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayLightTestExamples.java,v 8.12 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayLightTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: Create a <code>JunOpenGLDisplayLight</code> and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGLDisplayLight displayLight = new JunOpenGLDisplayLight();
		displayLight.open();

		return true;
	}

	/**
	 * Example2: Create a <code>JunOpenGLDisplayLight</code> and open it as a position light.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGLDisplayLight displayLight = new JunOpenGLDisplayLight();
		displayLight.lightName_("Position Light");
		displayLight.openPositionLight();

		return true;
	}

	/**
	 * Example3: Open an ambient light.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunOpenGLDisplayLight displayLight = JunOpenGLDisplayLight.AmbientLight_color_(true, Color.red);
		displayLight.lightName_("Ambient Light");
		displayLight.openAmbientLight();

		return true;
	}

	/**
	 * Example4: Create a parallel light and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunOpenGLDisplayLight displayLight = JunOpenGLDisplayLight.ParallelLight_color_position_(true, Color.green, new Jun3dPoint(1, 0, -1));
		displayLight.lightName_("Parallel Light");
		displayLight.openParallelLight();

		return true;
	}

	/**
	 * Example5: Create a spot light and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunOpenGLDisplayLight displayLight = JunOpenGLDisplayLight.SpotLight_color_position_direction_cutoffAngle_(true, Color.gray, new Jun3dPoint(1, 1, -1), new Jun3dPoint(-1, -1, 1), JunAngle.FromDeg_(10));
		displayLight.lightName_("Spot Light");
		displayLight.open();

		return true;
	}

	/**
	 * Example6: Create a point light and open it.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunOpenGLDisplayLight displayLight = JunOpenGLDisplayLight.PointLight_color_position_(true, Color.blue, new Jun3dPoint(1, 1, 0));
		displayLight.lightName_("Point Light");
		displayLight.open();

		return true;
	}

	/**
	 * Example7: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		JunOpenGL3dTransformedObject transformedObject = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.Ball());
		transformedObject = (JunOpenGL3dTransformedObject) transformedObject.scaledBy_(new Jun3dPoint(0.65, 1, 1.1));
		if (StInputState.Default().shiftDown() || StInputState.Default().altDown()) {
			transformedObject.establishAllNormalVectors();
		}
		transformedObject.showIn_(new Rectangle(100, 300, 400, 400));

		JunOpenGL3dObject compoundObject = transformedObject.transformedObject();
		compoundObject.showIn_(new Rectangle(510, 300, 400, 400));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLDisplayLightTestExamples();
	}
}
