package jp.co.sra.jun.opengl.display;

import java.awt.Dimension;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunOpenGLDisplayObjectsViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2006/07/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayObjectsViewAwt.java,v 8.11 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayObjectsViewAwt extends JunAbstractViewPanel implements JunOpenGLDisplayObjectsView {

	protected JunOpenGLDisplayViewAwt viewfinder;
	protected List methodList;

	/**
	 * Create a new instance of JunOpenGLDisplayObjectsViewAwt and initialize it.
	 *
	 * @param anOpenGLDisplayObjects jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjects
	 * @category Instance creation
	 */
	public JunOpenGLDisplayObjectsViewAwt(JunOpenGLDisplayObjects anOpenGLDisplayObjects) {
		super(anOpenGLDisplayObjects);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.viewfinder(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -200, 1f, -1));
		this.add(this.methodList(), WindowSpecLayout.Position(1f, -199, 0f, 1, 1f, -1, 1f, -1));
		this.setSize(new Dimension(500, 300));
	}

	/**
	 * Answer my model as JunOpenGLDisplayObjects.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjects
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayObjectsView#getOpenGLDisplayObjects()
	 * @category model accessing
	 */
	public JunOpenGLDisplayObjects getOpenGLDisplayObjects() {
		return (JunOpenGLDisplayObjects) this.model();
	}

	/**
	 * Answer the viewfinder.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt
	 * @category user interface
	 */
	protected JunOpenGLDisplayViewAwt viewfinder() {
		if (viewfinder == null) {
			viewfinder = new JunOpenGLDisplayViewAwt(this.getOpenGLDisplayObjects());
		}
		return viewfinder;
	}

	/**
	 * Answer the method list.
	 * 
	 * @return java.awt.List
	 * @category uesr interface
	 */
	protected List methodList() {
		if (methodList == null) {
			methodList = new List();
			methodList.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					if (e.getStateChange() == ItemEvent.SELECTED) {
						getOpenGLDisplayObjects().selectionIndex_(((Number) e.getItem()).intValue());
					}
				}
			});

			this.updateMethodList();
		}
		return methodList;
	}

	/**
	 * Update for the change notice.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StViewJPanel#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("methods")) {
			this.updateMethodList();
		} else {
			super.update_(e);
		}
	}

	/**
	 * Update the method list.
	 * 
	 * @category updating
	 */
	protected void updateMethodList() {
		this.methodList().removeAll();

		Method[] methods = this.getOpenGLDisplayObjects().methods();
		for (int i = 0; i < methods.length; i++) {
			Method aMethod = methods[i];
			String classname = aMethod.getDeclaringClass().getName();
			classname = classname.substring(classname.lastIndexOf('.') + 1);
			String aString = aMethod.getName() + " {" + classname + '}';
			this.methodList().add(aString);
		}

		int index = this.getOpenGLDisplayObjects().selectionIndex();
		if (index >= 0) {
			this.methodList().select(index);
			this.methodList().makeVisible(index);
		}
	}

}
