package jp.co.sra.jun.opengl.display;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;

/**
 * JunOpenGLShowController class
 * 
 *  @author    He Weijie
 *  @created   1998/11/26 (by He Weijie)
 *  @updated   2000/01/13 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/08/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLShowController.java,v 8.14 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLShowController extends JunOpenGLDisplayController implements MouseListener, MouseMotionListener {

	protected transient JunOpenGLShowView view;
	protected transient Point startPoint;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StController#initialize()
	 * @category initialize-release
	 */
	public void initialize() {
		super.initialize();
		view = null;
		startPoint = null;
	}

	/**
	 * Remove references to objects that may refer to the receiver.
	 * Remove the listeners of the view here as well.
	 * 
	 * @see jp.co.sra.smalltalk.StController#release()
	 * @category initialize-release
	 */
	public void release() {
		Component drawable = this.getOpenGLDrawable().toComponent();
		drawable.removeMouseListener(this);
		drawable.removeMouseMotionListener(this);

		super.release();
	}

	/**
	 * Add myself as a listener of the view.
	 * 
	 * @param newView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	protected void buildListener(StView newView) {
		Component drawable = this.getOpenGLDrawable().toComponent();
		drawable.addMouseListener(this);
		drawable.addMouseMotionListener(this);
	}

	/**
	 * Answer my model as JunOpenGLShowModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLShowModel
	 * @category model accessing
	 */
	protected JunOpenGLShowModel getOpenGLShowModel() {
		return (JunOpenGLShowModel) this.model();
	}

	/**
	 * Invoked when a mouse button has been pressed.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent event) {
		startPoint = event.getPoint();
	}

	/**
	 * Invoked when a mouse button has been released. cursor reset to default.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent event) {
		this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}

	/**
	 * general dragging action.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseDragged(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseDragged(MouseEvent event) {
		if (event.isMetaDown()) {
			return;
		}

		Point currentPoint = event.getPoint();
		Point previousPoint = startPoint;
		if (!currentPoint.equals(previousPoint)) {
			this.mouseDraggedFrom_to_with_(previousPoint, currentPoint, event);
			startPoint = currentPoint;
		}
	}

	/**
	 * Action for the mouse drag.
	 * 
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @param event java.awt.event.MouseEvent
	 * @category control defaults
	 */
	public void mouseDraggedFrom_to_with_(Point fromPoint, Point toPoint, MouseEvent event) {
		StSymbol state = this.getOpenGLShowModel().buttonState();
		if (state == $("bull")) {
			this.bullActivityFrom_to_(fromPoint, toPoint);
		} else if (state == $("grab")) {
			this.grabActivityFrom_to_(fromPoint, toPoint);
		} else if (state == $("drag")) {
			this.dragActivityFrom_to_with_(fromPoint, toPoint, event);
		}
	}

	/**
	 * Bull action definition.
	 * 
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @category control defaults
	 */
	protected void bullActivityFrom_to_(Point fromPoint, Point toPoint) {
		this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));

		Jun2dPoint currentPoint = this.regularizePoint_(toPoint);
		Jun2dPoint previousPoint = this.regularizePoint_(fromPoint);

		if (!currentPoint.equals(previousPoint)) {
			this.getOpenGLShowModel().bull_xy_(currentPoint, previousPoint);
		}

		this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		this.getOpenGLShowModel().changed_($("object"));
	}

	/**
	 * dragging action definition.
	 * 
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @param event java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void dragActivityFrom_to_with_(Point fromPoint, Point toPoint, MouseEvent event) {
		this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR));

		Jun2dPoint currentPoint = this.regularizePoint_(toPoint);
		Jun2dPoint startPoint = this.regularizePoint_(fromPoint);
		if (currentPoint.equals(startPoint)) {
			return;
		}

		if (event.isShiftDown()) {
			this.getOpenGLShowModel().look_xy_(startPoint, currentPoint);
		} else {
			this.getOpenGLShowModel().slide_xy_(startPoint, currentPoint);
		}
	}

	/**
	 * Grabbing action definition.
	 * 
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @category control defaults
	 */
	protected void grabActivityFrom_to_(Point fromPoint, Point toPoint) {
		this.getOpenGLDrawable().toComponent().setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

		Jun2dPoint currentPoint = regularizePoint_(toPoint);
		Jun2dPoint previousPoint = regularizePoint_(fromPoint);
		if (!currentPoint.equals(previousPoint)) {
			this.getOpenGLShowModel().grab_xy_(previousPoint, currentPoint);
		}
	}

	/**
	 * Regularize the point on the current view.
	 * 
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category private
	 */
	protected Jun2dPoint regularizePoint_(Point aPoint) {
		Dimension bounds = this.getOpenGLDrawable().toComponent().getSize();
		double x = (aPoint.x - bounds.width / 2.0) / (bounds.height / 2.0);
		double y = -(aPoint.y - bounds.height / 2.0) / (bounds.height / 2.0);
		return new Jun2dPoint(x, y);
	}

}
