package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLStereoDisplayModelTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/10/13 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun623 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStereoDisplayModelTestExamples.java,v 8.10 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLStereoDisplayModelTestExamples extends JunTestExamples {
	/**
	 * Example: Show OpenGL Stereo Model.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunOpenGLStereoDisplayModel displayModel = new JunOpenGLStereoDisplayModel();
		displayModel.open();

		return true;
	}

	/**
	 * Example2: Show OpenGL Stereo Model with cube.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.paint_(new Color(255, 235, 215));
		JunOpenGLStereoDisplayModel displayModel = new JunOpenGLStereoDisplayModel();
		displayModel.displayObject_(aCube);
		displayModel.open();

		return true;
	}

	/**
	 * Example21: Show OpenGL Stereo Model with cube.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example21() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.paint_(Color.gray);
		JunOpenGLStereoDisplayModel displayModel = new JunOpenGLStereoDisplayModel();
		displayModel.displayObject_(aCube);
		displayModel.open();
		displayModel.parallelProjection();
		displayModel.wireframePresentation();
		displayModel.crossing_(true);

		return true;
	}

	/**
	 * Example8: Show OpenGL Stereo Model with benzene.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Benzene();
		JunOpenGLStereoDisplayModel displayModel = new JunOpenGLStereoDisplayModel();
		displayModel.displayObject_(displayObject);
		displayModel.open();
		displayModel.viewFactor_(1.2);
		
		return true;
	}

	/**
	 * Example81: Show OpenGL Stereo Model with benzene.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example81() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Benzene();
		JunOpenGLStereoDisplayModel displayModel = new JunOpenGLStereoDisplayModel();
		displayModel.displayObject_(displayObject);
		displayModel.open();
		displayModel.viewFactor_(1.2);
		displayModel.parallelProjection();
		displayModel.hiddenlinePresentation();
		displayModel.crossing_(true);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLStereoDisplayModelTestExamples();
	}
}
