package jp.co.sra.jun.opengl.flux;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunOpenGLFluxMakerTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2006/10/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxMakerTestExamples.java,v 8.12 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxMakerTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return true
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGLFluxMaker fluxMaker = new JunOpenGLFluxMaker(_ExampleSegments());
		fluxMaker.segmentTransformations();

		Jun3dPoint[][] lineSegments = fluxMaker.lineSegments();
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		for (int index = 0; index < lineSegments.length; index++) {
			Jun3dPoint[] aSegment = lineSegments[index];
			JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(aSegment);
			aPolyline.paint_(Color.getHSBColor((float) ((double) index / (double) fluxMaker.lineSegments.size()), (float) 1.0d, (float) 1.0d));
			compoundObject.add_(aPolyline);
		}

		compoundObject.add_(JunOpenGL3dObject.Axes().transform_(Jun3dTransformation.Scale_(5)));
		compoundObject.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 * @category Examples
	 */
	public static boolean ManualExample1() {
		class FluxMakerTest {
			// segmentsBlock
			public Vector segmentsBlock() {
				Vector lineSegments; // (Jun3dPoint[2])[]
				int angleDegrees;

				lineSegments = new Vector();
				angleDegrees = 15;

				for (int degrees = 0; degrees <= (360 - angleDegrees); degrees += angleDegrees) {
					Jun3dTransformation aT;
					Jun3dPoint[] segment;

					aT = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(degrees));
					segment = new Jun3dPoint[] { (Jun3dPoint) new Jun3dPoint(0, 1.5, 0).transform_(aT), (Jun3dPoint) new Jun3dPoint(0, 1.2, 0).transform_(aT) };
					lineSegments.addElement(segment);
				}

				return lineSegments;
			}

			// show1Block
			public void show1Block() {
				JunOpenGL3dObject axesObject;
				JunOpenGL3dCompoundObject compoundObject;
				Vector lineSegments; // (Jun3dPoint[2])[]

				axesObject = JunOpenGL3dObject.Axes().scaledBy_(2);
				compoundObject = new JunOpenGL3dCompoundObject(axesObject);
				lineSegments = segmentsBlock();

				for (int i = 0; i < lineSegments.size(); i++) {
					Jun3dPoint[] segment = (Jun3dPoint[]) lineSegments.elementAt(i);
					JunOpenGL3dPolyline polyline;

					polyline = new JunOpenGL3dPolyline(segment);
					polyline.paint_(Color.gray);
					compoundObject.add_(polyline);
				}

				compoundObject.show();
			}

			// show2Block
			public void show2Block() {
				JunOpenGLFluxMaker fluxMaker;
				JunOpenGL3dObject axesObject;
				JunOpenGLFluxMutableObject mutableObject;
				JunOpenGLFluxImmutableObject immutableObject;
				JunOpenGL3dCompoundObject compoundObject;
				JunOpenGLFluxObject fluxObject;

				fluxMaker = new JunOpenGLFluxMaker(segmentsBlock());
				axesObject = JunOpenGL3dObject.Axes2();
				mutableObject = new JunOpenGLFluxMutableObject(axesObject);

				for (int i = 0; i < fluxMaker.segmentTransformations().length; i++) {
					Jun3dTransformation aT = fluxMaker.segmentTransformations()[i];
					mutableObject.add_(aT);
				}

				axesObject = JunOpenGL3dObject.Axes().scaledBy_(2);
				immutableObject = new JunOpenGLFluxImmutableObject(axesObject);
				compoundObject = new JunOpenGL3dCompoundObject();
				compoundObject.add_(mutableObject.compoundObject());
				compoundObject.add_(immutableObject.compoundObject());
				compoundObject.show();
				fluxObject = new JunOpenGLFluxObject();
				fluxObject.addImmutable_(immutableObject);
				fluxObject.addMutable_(mutableObject);
				fluxObject.show();
			}

			// satelliteBlock
			public JunOpenGL3dObject satelliteBlock() {
				JunOpenGL3dObject box1;
				JunOpenGL3dObject box2;
				JunOpenGL3dCompoundObject satellite;

				box1 = JunOpenGL3dObject.Box_(new Jun3dPoint(0.4, 0.4, 0.4));
				box1.paint_(Color.gray);
				box2 = JunOpenGL3dObject.Box_(new Jun3dPoint(0.4, 0.4, 0.4));
				box2 = box2.translatedBy_(new Jun3dPoint(0, 0, 0.4));
				box2.paint_(Color.yellow);
				satellite = new JunOpenGL3dCompoundObject(box1, box2);

				return satellite.translatedBy_(new Jun3dPoint(-0.2, -0.2, 0));
			}

			// show3Block
			public void show3Block() {
				JunOpenGLFluxMaker fluxMaker;
				JunOpenGLFluxMutableObject mutableObject;
				JunOpenGL3dObject axesObject;
				JunOpenGLFluxImmutableObject immutableObject;
				JunOpenGL3dCompoundObject compoundObject;
				JunOpenGLFluxObject fluxObject;

				fluxMaker = new JunOpenGLFluxMaker(segmentsBlock());
				mutableObject = new JunOpenGLFluxMutableObject(satelliteBlock());

				for (int i = 0; i < fluxMaker.segmentTransformations().length; i++) {
					Jun3dTransformation aT = fluxMaker.segmentTransformations()[i];
					mutableObject.add_(aT);
				}

				axesObject = JunOpenGL3dObject.Axes().scaledBy_(2);
				immutableObject = new JunOpenGLFluxImmutableObject(axesObject);
				compoundObject = new JunOpenGL3dCompoundObject();
				compoundObject.add_(mutableObject.compoundObject());
				compoundObject.add_(immutableObject.compoundObject());
				compoundObject.show();
				fluxObject = new JunOpenGLFluxObject();
				fluxObject.addImmutable_(immutableObject);
				fluxObject.addMutable_(mutableObject);
				fluxObject.show();
			}

			// earthBlock
			public JunOpenGL3dObject earthBlock() {
				JunOpenGL3dObject earthObject;

				earthObject = JunOpenGL3dObject.Sphere_(20);
				earthObject.paint_(Color.cyan);

				return earthObject;
			}

			// show4Block
			public void show4Block() {
				JunOpenGLFluxMaker fluxMaker;
				JunOpenGLFluxMutableObject mutableObject;
				JunOpenGLFluxImmutableObject immutableObject;
				JunOpenGL3dCompoundObject compoundObject;
				JunOpenGLFluxObject fluxObject;
				JunOpenGLFluxModel fluxModel;

				fluxMaker = new JunOpenGLFluxMaker(segmentsBlock());
				mutableObject = new JunOpenGLFluxMutableObject(satelliteBlock());

				for (int i = 0; i < fluxMaker.segmentTransformations().length; i++) {
					Jun3dTransformation aT = fluxMaker.segmentTransformations()[i];
					mutableObject.add_(aT);
				}

				immutableObject = new JunOpenGLFluxImmutableObject(earthBlock());
				compoundObject = new JunOpenGL3dCompoundObject();
				compoundObject.add_(mutableObject.compoundObject());
				compoundObject.add_(immutableObject.compoundObject());
				compoundObject.show();
				fluxObject = new JunOpenGLFluxObject();
				fluxObject.addImmutable_(immutableObject);
				fluxObject.addMutable_(mutableObject);
				fluxModel = new JunOpenGLFluxModel(fluxObject);
				fluxModel.trackerModel().loop();
				fluxModel.open();
			}
		}

		FluxMakerTest test = new FluxMakerTest();
		test.show1Block();
		test.show2Block();
		test.show3Block();
		test.show4Block();

		return true;
	}

	/**
	 * Create an example segments.
	 * 
	 * @return java.util.Collection
	 * @category Examples
	 */
	protected static Collection _ExampleSegments() {
		return _ExampleSegments_(10);
	}

	/**
	 * Create an example segments.
	 * 
	 * @param angleDegrees int
	 * @return java.util.Collection
	 * @category Examples 
	 */
	protected static Collection _ExampleSegments_(int angleDegrees) {
		return _ExampleSegments_rotationSelector_(angleDegrees, "RotateY_");
	}

	/**
	 * Create an example segments.
	 * 
	 * @param angleDegrees int
	 * @param messageSelector java.lang.String
	 * @return java.util.Collection
	 * @category Examples 
	 */
	protected static Collection _ExampleSegments_rotationSelector_(int angleDegrees, String messageSelector) {
		Jun3dPoint fromPoint = new Jun3dPoint(0, 0, 0);
		Jun3dPoint toPoint = new Jun3dPoint(1, 1, 1);
		Jun3dTransformation aT = Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 2));
		fromPoint = fromPoint.transform_(aT);
		toPoint = toPoint.transform_(aT);
		Jun3dPoint aVector = toPoint.minus_(fromPoint);
		Jun3dTransformation originalTranslation = Jun3dTransformation.Translate_(fromPoint);
		ArrayList segmentCollection = new ArrayList();

		for (int degrees = 0; degrees <= 360 - angleDegrees; degrees += angleDegrees) {
			Jun3dTransformation rotationT = Jun3dTransformation.Unity();
			if (messageSelector.equals("RotateX_")) {
				rotationT = rotationT.product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(degrees)));
			} else if (messageSelector.equals("RotateY_")) {
				rotationT = rotationT.product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(degrees)));
			} else if (messageSelector.equals("RotateZ_")) {
				rotationT = rotationT.product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(degrees)));
			}

			Jun3dTransformation scalingT = Jun3dTransformation.Scale_(new Jun3dPoint(1, 1, (1 + (1 * ((double) degrees / 360.0d)))));
			Jun3dTransformation translationT = Jun3dTransformation.Translate_(new Jun3dPoint(4 * ((double) degrees / 360.0d), 0, 0));
			aT = Jun3dTransformation.Unity();
			aT = aT.product_(scalingT);
			aT = aT.product_(originalTranslation);
			aT = aT.product_(rotationT);
			aT = aT.product_(translationT);
			Jun3dPoint aPoint0 = new Jun3dPoint(0, 0, 0).transform_(aT);
			Jun3dPoint aPoint1 = aVector.transform_(aT);
			segmentCollection.add(new Jun3dPoint[] { aPoint0, aPoint1 });
		}

		return segmentCollection;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLFluxMakerTestExamples();
	}

}
