package jp.co.sra.jun.opengl.illusion;

import java.util.ArrayList;
import java.util.List;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.colors.JunColorBarCMY;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLIllusion02 class
 * 
 *  @author    nisinaka
 *  @created   2004/09/27 (by nisinaka)
 *  @updated   2006/10/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun655 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLIllusion02.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLIllusion02 extends JunOpenGLIllusion {
	protected int numberOfParts;
	protected JunColorBarCMY colorBar;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		numberOfParts = this.defaultNumberOfParts();
		colorBar = null;
	}

	/**
	 * Answer my current number of parts.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int numberOfParts() {
		return numberOfParts;
	}

	/**
	 * Set my new number of parts.
	 * 
	 * @param newNumberOfParts int
	 * @category accessing
	 */
	public void numberOfParts_(int newNumberOfParts) {
		numberOfParts = newNumberOfParts;
		fluxModel = null;
	}

	/**
	 * Answer my current color bar.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarCMY
	 * @category color accessing
	 */
	public JunColorBarCMY colorBar() {
		if (colorBar == null) {
			colorBar = this.makeColorBar();
		}
		return colorBar;
	}

	/**
	 * Answer my default number of parts.
	 * 
	 * @return int
	 * @category defaults
	 */
	protected int defaultNumberOfParts() {
		return 11;
	}

	/**
	 * Answer my default frame factors of stages.
	 * 
	 * @return java.util.List
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#defaultFramesOfStages()
	 * @category defaults
	 */
	protected List defaultFramesOfStages() {
		int size = this.numberOfParts() * 3;
		ArrayList aList = new ArrayList(size);
		for (int i = 0; i < size; i++) {
			aList.add(new Integer(this.defaultFramesOfStage()));
		}
		return aList;
	}

	/**
	 * Ansewr my default number of frames of a stage. 
	 * 
	 * @return int
	 * @category defaults
	 */
	protected int defaultFramesOfStage() {
		return 10;
	}

	/**
	 * Answer my default eye point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#defaultEyePoint()
	 * @category defaults
	 */
	protected Jun3dPoint defaultEyePoint() {
		return new Jun3dPoint(0, this.numberOfParts() / Math.sqrt(2), this.numberOfParts() * 100);
	}

	/**
	 * Answer my default sight point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#defaultSightPoint()
	 * @category defaults
	 */
	protected Jun3dPoint defaultSightPoint() {
		return new Jun3dPoint(0, this.numberOfParts() / Math.sqrt(2), 0);
	}

	/**
	 * Answer my default zoom height.
	 * 
	 * @return double
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#defaultZoomHeight()
	 * @category defaults
	 */
	protected double defaultZoomHeight() {
		return (double) this.numberOfParts() * 5;
	}

	/**
	 * Create my flux model.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxModel
	 * @see jp.co.sra.jun.opengl.illusion.JunOpenGLIllusion#makeFluxModel()
	 * @category making
	 */
	protected JunOpenGLFluxModel makeFluxModel() {
		JunOpenGLFluxObject aFluxObject = new JunOpenGLFluxObject();
		for (int i = 1; i <= this.numberOfParts(); i++) {
			aFluxObject.addMutable_(this.cube_(i));
		}
		return new JunOpenGLFluxModel(aFluxObject);
	}

	/**
	 * Create my color bar.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarCMY
	 * @category making
	 */
	protected JunColorBarCMY makeColorBar() {
		JunColorBarCMY aColorBar = new JunColorBarCMY();
		aColorBar.firstMarker_(0);
		aColorBar.lastMarker_(1);
		aColorBar.value_(0);
		aColorBar.cyanBounds_(new double[] { 0, 1 });
		aColorBar.magentaBounds_(new double[] { 0, 1 });
		aColorBar.yellowBounds_(new double[] { 0, 1 });
		return aColorBar;
	}

	/**
	 * Create the specified cube.
	 * 
	 * @param indexOfParts int
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category parts
	 */
	protected JunOpenGLFluxMutableObject cube_(int indexOfParts) {
		JunOpenGL3dObject a3dObject = this.baseCube();
		a3dObject = a3dObject.scaledBy_(new Jun3dPoint(indexOfParts, indexOfParts, 1 + this.numberOfParts() - indexOfParts));
		this.colorBar().value_((double) indexOfParts / this.numberOfParts());
		a3dObject.paint_(this.colorBar().color());
		JunOpenGLFluxMutableObject mutableObject = new JunOpenGLFluxMutableObject(a3dObject);

		Jun3dPoint startPoint = new Jun3dPoint(0, this.numberOfParts() * Math.sqrt(2) * 4, 0);
		Jun3dPoint waitPoint = new Jun3dPoint(0, this.numberOfParts() * Math.sqrt(2) - 1, 0);
		Jun3dPoint stopPoint = new Jun3dPoint(0, 0, 0);
		int movingIndexOfParts = 1 + this.numberOfParts() - indexOfParts;
		Jun3dTransformation[] transformations = null;
		for (int stageIndex = 1; stageIndex <= this.numberOfStages(); stageIndex++) {
			int partsIndex = (stageIndex - 1) / 3 + 1;
			int localIndex = stageIndex % 3;
			if (partsIndex < movingIndexOfParts) {
				transformations = this.transformationsFrom_to_step_(startPoint, startPoint, this.framesOfStageAt_(stageIndex));
			} else if (partsIndex == movingIndexOfParts) {
				if (localIndex == 1) {
					transformations = this.transformationsFrom_to_step_(startPoint, waitPoint, this.framesOfStageAt_(stageIndex));
				} else if (localIndex == 2) {
					transformations = this.transformationsFrom_to_step_(waitPoint, waitPoint, this.framesOfStageAt_(stageIndex));
				} else if (localIndex == 0) {
					transformations = this.transformationsFrom_to_step_(waitPoint, stopPoint, this.framesOfStageAt_(stageIndex));
				}
			} else if (partsIndex > movingIndexOfParts) {
				transformations = this.transformationsFrom_to_step_(stopPoint, stopPoint, this.framesOfStageAt_(stageIndex));
			}

			for (int i = 0; i < transformations.length; i++) {
				mutableObject.add_(transformations[i]);
			}
		}

		return mutableObject;
	}

	/**
	 * Create a base cube.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category parts
	 */
	protected JunOpenGL3dObject baseCube() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		Jun3dTransformation aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(45));
		aCube = aCube.transform_(aTransformation);
		return aCube;
	}
}
