package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLAmbientLight class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/10/23 (by MATSUDA Ryouichi)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLAmbientLight.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLAmbientLight extends JunOpenGLLight {

	/**
	 * Create a new instance of JunOpenGLAmbientLight and initialize it.
	 *
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGLAmbientLight(Color aColor) {
		this.setColor_alpha_(aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLAmbientLight and initialize it.
	 *
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGLAmbientLight(Color aColor, float aNumber) {
		this.setColor_alpha_(aColor, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGLAmbientLight and initialize it.
	 * 
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLAmbientLight
	 * @category Instance creation
	 */
	public static JunOpenGLAmbientLight Color_(Color aColor) {
		return new JunOpenGLAmbientLight(aColor);
	}

	/**
	 * Create a new instance of JunOpenGLAmbientLight and initialize it.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLAmbientLight
	 * @category Instance creation
	 */
	public static JunOpenGLAmbientLight Color_alpha_(Color aColor, float aNumber) {
		return new JunOpenGLAmbientLight(aColor, aNumber);
	}

	/**
	 * Lighting on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#lightingOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category lighting
	 */
	public void lightingOn_(JunOpenGLRenderingContext aRenderingContext) {
		aRenderingContext.lightAmbientColor_alpha_(this.color, this.alpha);
		aRenderingContext.enableLighting();
	}

	/**
	 * Transformation on the light.
	 * 
	 * @param aJun3dTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLLight
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#transform_(jp.co.sra.jun.geometry.transformations.Jun3dTransformation)
	 * @category transforming
	 */
	public JunOpenGLLight transform_(Jun3dTransformation aJun3dTransformation) {
		return (JunOpenGLAmbientLight) this.copy();
	}

	/**
	 * Set the color with the alpha number.
	 * 
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @category private
	 */
	protected void setColor_alpha_(Color aColorValue, float aNumber) {
		color = aColorValue;
		alpha = aNumber;
	}

}
