package jp.co.sra.jun.opengl.lights;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;

/**
 * JunOpenGLSpotLight class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/10/23 (by MATSUDA Ryouichi)
 *  @updated   1999/05/10 (by kondo)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLSpotLight.java,v 8.11 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLSpotLight extends JunOpenGLLight {

	protected Jun3dPoint position;
	protected Jun3dPoint direction;
	protected JunAngle cutoffAngle;

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param direction jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param cutoffAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGLSpotLight(Jun3dPoint position, Jun3dPoint direction, JunAngle cutoffAngle, Color aColor, float aNumber) {
		this.setPosition_direction_cutoffAngle_color_alpha_(position, direction, cutoffAngle, aColor, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category Instance creation
	 */
	public static JunOpenGLSpotLight At3dPoint_(Jun3dPoint position) {
		return At3dPoint_color_(position, DefaultColor());
	}

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public static JunOpenGLSpotLight At3dPoint_color_(Jun3dPoint position, Color aColor) {
		return At3dPoint_color_alpha_(position, aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public static JunOpenGLSpotLight At3dPoint_color_alpha_(Jun3dPoint position, Color aColor, float aNumber) {
		return At3dPoint_direction_cutoffAngle_color_alpha_(position, null, null, aColor, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param direction jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param cutoffAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public static JunOpenGLSpotLight At3dPoint_direction_cutoffAngle_color_(Jun3dPoint position, Jun3dPoint direction, JunAngle cutoffAngle, Color aColor) {
		return At3dPoint_direction_cutoffAngle_color_alpha_(position, direction, cutoffAngle, aColor, DefaultAlpha());
	}

	/**
	 * Create a new instance of JunOpenGLSpotLight and initialize it.
	 *
	 * @param position jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param direction jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param cutoffAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public static JunOpenGLSpotLight At3dPoint_direction_cutoffAngle_color_alpha_(Jun3dPoint position, Jun3dPoint direction, JunAngle cutoffAngle, Color aColor, float aNumber) {
		return new JunOpenGLSpotLight(position, direction, cutoffAngle, aColor, aNumber);
	}

	/**
	 * Answer my current position.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint position() {
		return position;
	}

	/**
	 * Set my new position.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void position_(Jun3dPoint a3dPoint) {
		position = a3dPoint;
	}

	/**
	 * Answer my current direction.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint direction() {
		return direction;
	}

	/**
	 * Set my new direction.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void direction_(Jun3dPoint a3dPoint) {
		direction = a3dPoint;
	}

	/**
	 * Answer my current cutoff angle.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @category accessing
	 */
	public JunAngle cutoffAngle() {
		return cutoffAngle;
	}

	/**
	 * Set my new cutoff angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @category accessing
	 */
	public void cutoffAngle_(JunAngle anAngle) {
		cutoffAngle = anAngle;
	}

	/**
	 * Lighting on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#lightingOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category lighting
	 */
	public void lightingOn_(JunOpenGLRenderingContext aRenderingContext) {
		Jun3dPoint lightingDirection = this.direction();
		if (lightingDirection == null) {
			lightingDirection = (Jun3dPoint) aRenderingContext.projection().sightPoint().minus_(this.position());
		}
		JunAngle lightingAngle = this.cutoffAngle();
		if (lightingAngle == null) {
			lightingAngle = JunAngle.FromDeg_(45);
		}

		int index = aRenderingContext.getLightIndex();
		aRenderingContext.lightIndex_position_direction_cutoffAngle_color_alpha_(index, this.position(), lightingDirection, lightingAngle, this.color(), this.alpha());
		aRenderingContext.enableLightIndex_(index);
		aRenderingContext.enableLighting();
	}

	/**
	 * Transformation on the light.
	 * 
	 * @param aJun3dTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.lights.JunOpenGLLight
	 * @see jp.co.sra.jun.opengl.lights.JunOpenGLLight#transform_(jp.co.sra.jun.geometry.transformations.Jun3dTransformation)
	 * @category transforming
	 */
	public JunOpenGLLight transform_(Jun3dTransformation aJun3dTransformation) {
		JunOpenGLSpotLight transformed = (JunOpenGLSpotLight) this.copy();
		transformed.position_(this.position().transform_(aJun3dTransformation));
		if (direction != null) {
			transformed.direction_(this.direction().transform_(aJun3dTransformation).minus_(Jun3dPoint.Zero().transform_(aJun3dTransformation)));
		}
		return transformed;
	}

	/**
	 * Set the position, color and alpha.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @category private
	 */
	protected void setPosition_color_alpha_(Jun3dPoint a3dPoint, Color aColorValue, float aNumber) {
		position = a3dPoint;
		color = aColorValue;
		alpha = aNumber;
	}

	/**
	 * Set the position, color and alpha.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param a3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @category private
	 */
	protected void setPosition_direction_cutoffAngle_color_alpha_(Jun3dPoint a3dPoint, Jun3dPoint a3dPoint2, JunAngle aJunAngle, Color aColorValue, float aNumber) {
		position = a3dPoint;
		direction = a3dPoint2;
		cutoffAngle = aJunAngle;
		color = aColorValue;
		alpha = aNumber;
	}

}
