package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.util.HashMap;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dCompoundObjectTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/05/12 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dCompoundObjectTestExamples.java,v 8.15 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dCompoundObjectTestExamples extends JunTestExamples {

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunOpenGL3dObject object = JunOpenGL3dObject.Cube();
		System.out.println(object.area());

		JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
		Jun3dTriangle[] triangles = object.asTriangles();
		for (int i = 0; i < triangles.length; i++) {
			body.add_(triangles[i].asJunOpenGL3dObject());
		}

		body.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(2));

		HashMap projection = new HashMap();
		projection.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projection.put($("zoomHeight"), new Double(4));
		projection.put($("eyePoint"), new Jun3dPoint(15, 15, 15));
		projection.put($("viewFactor"), new Double(10));
		projection.put($("shading"), $("smoothShading"));
		projection.put($("presentation"), $("hiddenlinePresentation"));
		projection.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		body.showProjectionTable_(projection);

		return true;
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunOpenGL3dObject object = JunOpenGL3dObject.Globe();
		System.out.println(object.area());

		JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();
		Jun3dTriangle[] triangles = object.asTriangles();
		for (int i = 0; i < triangles.length; i++) {
			JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) triangles[i].asJunOpenGL3dObject();
			Jun3dPoint[] points = polygon.vertexes();
			for (int j = 0; j < points.length; j++) {
				points[j] = new Jun3dLine(new Jun3dPoint(0, 0, 0), points[j]).normalUnitVector();
			}
			polygon.normalVectors_(points);

			body.add_(polygon);
		}

		body.add_(JunOpenGL3dObject.XyzArrows().scaledBy_(2));

		HashMap projection = new HashMap();
		projection.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projection.put($("zoomHeight"), new Double(4));
		projection.put($("eyePoint"), new Jun3dPoint(15, 15, 15));
		projection.put($("viewFactor"), new Double(10));
		projection.put($("shading"), $("smoothShading"));
		projection.put($("presentation"), $("hiddenlinePresentation"));
		projection.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		body.showProjectionTable_(projection);

		return true;
	}

	/**
	 * Show the typical object: Box with normal vectors object.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_BoxWithNormalVectorsObject() {
		JunOpenGL3dObject aBox = JunOpenGL3dObject.Box();
		aBox.paint_(Color.white);
		aBox.establishAllNormalVectorsWithSmoothingAngle_(JunAngle.FromDeg_(91));
		JunOpenGL3dObject.ShowWithNormalVectors_(aBox);

		return true;
	}

	/**
	 * Show the typical object: Cone
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cone() {
		JunOpenGL3dCone aCone = new JunOpenGL3dCone();
		aCone.paint_(Color.white);
		aCone.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cone with normal vectors object
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_ConeWithNormalVectorsObject() {
		JunOpenGL3dCone aCone = new JunOpenGL3dCone();
		aCone.paint_(Color.white);
		aCone.establishAllNormalVectors();
		JunOpenGL3dObject.ShowWithNormalVectors_(aCone);
		return true;
	}

	/**
	 * Show the typical object: Cone1
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cone1() {
		JunOpenGL3dCone aCone = new JunOpenGL3dCone(1, 2);
		aCone.paint_(Color.white);
		aCone.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cone2
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cone2() {
		JunOpenGL3dCone aCone = new JunOpenGL3dCone(new Jun3dPoint(0, 0, 0), new Jun3dPoint(-1, -1, -1), 1, 20);
		aCone.paint_(Color.white);
		aCone.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cone3
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cone3() {
		JunOpenGL3dCone aConeX = new JunOpenGL3dCone(new Jun3dPoint(-1, 0, 0), new Jun3dPoint(0, 0, 0), 1, 20);
		aConeX.paint_(Color.red);
		aConeX.showWithUnitAxes();
		JunOpenGL3dCone aConeY = new JunOpenGL3dCone(new Jun3dPoint(0, -1, 0), new Jun3dPoint(0, 0, 0), 1, 20);
		aConeY.paint_(Color.green);
		aConeY.showWithUnitAxes();
		JunOpenGL3dCone aConeZ = new JunOpenGL3dCone(new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 0), 1, 20);
		aConeZ.paint_(Color.blue);
		aConeZ.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cylinder
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cylinder() {
		JunOpenGL3dCylinder aCylinder = new JunOpenGL3dCylinder();
		aCylinder.paint_(Color.white);
		aCylinder.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cylinder with normal vectors object
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_CylinderWithNormalVectorsObject() {
		JunOpenGL3dCylinder aCylinder = new JunOpenGL3dCylinder();
		aCylinder.paint_(Color.white);
		aCylinder.establishAllNormalVectors();
		JunOpenGL3dObject.ShowWithNormalVectors_(aCylinder);
		return true;
	}

	/**
	 * Show the typical object: Cylinder
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cylinder1() {
		JunOpenGL3dCylinder aCylinder = new JunOpenGL3dCylinder(1, 2);
		aCylinder.paint_(Color.white);
		aCylinder.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Cylinder
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Cylinder2() {
		JunOpenGL3dCylinder aCylinder = new JunOpenGL3dCylinder(new Jun3dPoint(0, 0, 0), new Jun3dPoint(-1, -1, -1), 1, 20);
		aCylinder.paint_(Color.white);
		aCylinder.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Sphere
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Sphere() {
		JunOpenGL3dSphere aSphere = new JunOpenGL3dSphere(1.0, 40, 20);
		aSphere.paint_(Color.white);
		aSphere.showWithUnitAxes();
		return true;
	}

	/**
	 * Show the typical object: Sphere
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_SphereWithNormalVectorsObject() {
		JunOpenGL3dSphere aSphere = new JunOpenGL3dSphere(1.0, 40, 20);
		aSphere.paint_(Color.white);
		aSphere.establishAllNormalVectors();
		JunOpenGL3dObject.ShowWithNormalVectors_(aSphere);
		return true;
	}

	/**
	 * Show the typical object: Sphere
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_Spheres() {
		JunOpenGL3dSphere aSphere = new JunOpenGL3dSphere(1.0, 40, 20);
		aSphere.paint_(Color.white);
		JunOpenGL3dSphere aSphere2 = (JunOpenGL3dSphere) aSphere.transform_(Jun3dTransformation.Scale_(0.5).product_(Jun3dTransformation.Translate_(1)));
		aSphere2.paint_(Color.red);
		(new JunOpenGL3dCompoundObject(aSphere, aSphere2)).show();
		return true;
	}

	/**
	 * Test for the normal vectors.
	 * 
	 * @return boolean
	 * @category Tests
	 */
	public static boolean Test_NormalVectors() {
		Jun3dPoint p000 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint p001 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint p011 = new Jun3dPoint(0, 1, 1);
		Jun3dPoint p010 = new Jun3dPoint(0, 1, 0);

		JunOpenGL3dPolygon polygon1 = new JunOpenGL3dPolygon(new Jun3dPoint[] { p000, p001, p011, p010 });
		JunOpenGL3dPolygon polygon2 = (JunOpenGL3dPolygon) polygon1.rotatedBy_(JunAngle.FromDeg_(45));
		JunOpenGL3dPolygon polygon3 = (JunOpenGL3dPolygon) polygon1.rotatedBy_(JunAngle.FromDeg_(-45));

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject(polygon1, polygon2, polygon3);
		compoundObject.paint_(Color.white);
		compoundObject.establishAllNormalVectors();
		compoundObject.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dCompoundObjectTestExamples();
	}

}
