package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.util.HashMap;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;

/**
 * JunOpenGL3dVertexesTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/20 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2003/09/09 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun605 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dVertexesTestExamples.java,v 8.11 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dVertexesTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunOpenGL3dVertexesTestExamples();
	}

	/**
	 * Example1: Check if the preferred normal vector is correct.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Jun3dPoint p0 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint p2 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 1);
		Jun3dPoint[] points = { p0, p1, p3, p2 };
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(points);
		Jun3dPoint vector = aPolygon.normalVector();
		return (vector.x() == -1.0d) && (vector.y() == 0.0d) && (vector.z() == 0.0d);
	}

	/**
	 * Example5: Check if the colors can be specified.
	 * 
	 * @return boolean
	 */
	public static boolean Example5_1() {
		JunOpenGL3dPolygon polygon = ColoredPolygon();
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(polygon);
		displayModel.smoothShading();
		displayModel.open();
		return true;
	}

	/**
	 * Example5: Check if the colors can be specified.
	 * 
	 * @return boolean
	 */
	public static boolean Example5_2() {
		JunOpenGL3dPolygon polygon = ColoredPolygon();
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(polygon);
		displayModel.open();
		displayModel.smoothShading();
		return true;
	}

	/**
	 * Example6: Check if the preferred normal vector is correct.
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunOpenGL3dPolygon polygon = ColoredPolygon();
		polygon = (JunOpenGL3dPolygon) new JunOpenGL3dPolygon((JunLispCons) polygon.toLispList());
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(polygon);
		displayModel.defaultShading_($("smoothShading"));
		displayModel.open();
		return true;
	}

	/**
	 * Example8: Check if the polygon is converted as an array of triangles.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dCompoundObject body = new JunOpenGL3dCompoundObject();

		JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
		Jun3dTriangle[] triangles = polygon.asTriangles();
		for (int i = 0; i < triangles.length; i++) {
			body.add_(triangles[i].asJunOpenGL3dObject());
		}

		body.add_(JunOpenGL3dObject.Axes().scaledBy_(2));

		HashMap projection = new HashMap();
		projection.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projection.put($("zoomHeight"), new Double(4));
		projection.put($("eyePoint"), new Jun3dPoint(15, 15, 15));
		projection.put($("viewFactor"), new Double(10));
		projection.put($("shading"), $("smoothShading"));
		projection.put($("presentation"), $("hiddenlinePresentation"));
		projection.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		body.showProjectionTable_(projection);

		return true;
	}

	/**
	 * Answer the colored polygon.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 */
	protected static JunOpenGL3dPolygon ColoredPolygon() {
		JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 1), new Jun3dPoint(1, 1, 1), new Jun3dPoint(0, 1, 1) });
		polygon.colors_(new Color[] { Color.red, Color.yellow, Color.red, Color.blue });
		return polygon;
	}

}
