package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCone;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGL3dTypicalObjectsCone class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsCone.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsCone extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - cone
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ColorCone() {
		JunOpenGL3dCompoundObject aCompoundObject = (JunOpenGL3dCompoundObject) From_to_height_depth_with_(new Jun3dPoint(0, 0, 1), new Jun3dPoint(0, 0, 0), 2, 2, XUnitCone());
		aCompoundObject.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(Color.white);
				return null;
			}
		});
		List sideCollection = new ArrayList();
		List baseCollection = new ArrayList();
		JunOpenGL3dObject[] components = aCompoundObject.components();
		for (int i = 0; i < components.length; i++) {
			if ((i + 1) % 2 == 1) {
				sideCollection.add(components[i]);
			} else {
				baseCollection.add(components[i]);
			}
		}
		StImage anImage = JunOpenGL3dObject.ImageRBBR();
		JunOpenGL3dObject[] patches = (JunOpenGL3dObject[]) sideCollection.toArray(new JunOpenGL3dObject[sideCollection.size()]);
		for (int i = 0; i < patches.length; i++) {
			JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
			aTexture.linear_(false);
			aTexture.repeat_(false);
			aTexture.modulate_(false);
			Jun3dPoint p1_ = patches[i].asPointArray()[2];
			Jun2dPoint p1 = new Jun2dPoint(p1_.x(), p1_.y());
			Jun3dPoint p2_ = patches[i].asPointArray()[1];
			Jun2dPoint p2 = new Jun2dPoint(p2_.x(), p2_.y());
			Jun2dPoint p3 = p1.plus_(p2.minus_(p1).dividedBy_(2));
			double p1__ = Math.toDegrees(p1.theta()) / 360.0d;
			double p2__ = Math.toDegrees(p2.theta()) / 360.0d;
			if (p2__ == 0.0d) {
				p2__ = 1.0d;
			}
			double p3__ = Math.toDegrees(p3.theta()) / 360.0d;
			p1__ = 1.0d - p1__;
			p2__ = 1.0d - p2__;
			p3__ = 1.0d - p3__;
			aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(p3__, 0), new Jun2dPoint(p2__, 1), new Jun2dPoint(p1__, 1) });
			patches[i].texture_(aTexture);
		}
		anImage = JunOpenGL3dObject.ImageRGBR();
		patches = (JunOpenGL3dObject[]) baseCollection.toArray(new JunOpenGL3dObject[baseCollection.size()]);
		for (int i = 0; i < patches.length; i++) {
			JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
			aTexture.linear_(false);
			aTexture.repeat_(false);
			aTexture.modulate_(false);
			Jun2dPoint p1 = new Jun2dPoint(0, 0).plus_(new Jun2dPoint(0.5, 0.5));
			Jun3dPoint p2_ = patches[i].asPointArray()[1];
			Jun2dPoint p2 = new Jun2dPoint(p2_.x(), p2_.y()).dividedBy_(new Jun2dPoint(2, 2)).plus_(new Jun2dPoint(0.5, 0.5));
			Jun3dPoint p3_ = patches[i].asPointArray()[2];
			Jun2dPoint p3 = new Jun2dPoint(p3_.x(), p3_.y()).dividedBy_(new Jun2dPoint(2, 2)).plus_(new Jun2dPoint(0.5, 0.5));
			aTexture.coordinates_(new Jun2dPoint[] { p1, p2, p3 });
			patches[i].texture_(aTexture);
		}
		aCompoundObject.name_("color cone");
		return aCompoundObject;
	}

	/**
	 * Typical objects - cone
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone() {
		return Cone_(10);
	}

	/**
	 * Typical objects - cone
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone_(double degrees) {
		return Cone_radius_height_(degrees, 1, 2);
	}

	/**
	 * Typical objects - cone
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param height double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone_radius_height_(double degrees, double radius, double height) {
		JunOpenGL3dCompoundObject cone = new JunOpenGL3dCompoundObject();
		StBlockClosure rotationBlock = new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				Jun3dPoint p = (Jun3dPoint) o1;
				double t = ((Number) o2).doubleValue();
				double x = (p.x() * Math.cos(t)) - (p.y() * Math.sin(t));
				double y = (p.x() * Math.sin(t)) + (p.y() * Math.cos(t));
				if (Math.abs(x) < JunGeometry.ACCURACY) {
					x = 0.0d;
				}
				if (Math.abs(y) < JunGeometry.ACCURACY) {
					y = 0.0d;
				}
				return new Jun3dPoint(x, y, 0.0d);
			}
		};

		Jun3dPoint apex = new Jun3dPoint(0, 0, height);
		Jun3dPoint base = new Jun3dPoint(radius, 0, 0);
		Jun3dPoint base1 = base;
		for (double d = degrees; d <= 360; d += degrees) {
			Jun3dPoint base2 = (Jun3dPoint) rotationBlock.value_value_(base, new Double(JunAngle._DegreesToRadians(d)));
			JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { apex, base1, base2 });
			Jun3dPoint[] vertexes = polygon.vertexes();
			Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
			for (int i = 0; i < normalVectors.length; i++) {
				normalVectors[i] = new Jun3dPoint(0, 0, 0).to_(vertexes[i]).normalUnitVector();
			}
			polygon.normalVectors_(normalVectors);
			cone.add_(polygon);

			polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { Jun3dPoint.Zero(), base2, base1 });
			cone.add_(polygon);
			base1 = base2;
		}
		cone.flushAllPaints();
		cone.paint_(DefaultPaint());

		return cone;
	}

	/**
	 * Typical object - cone.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aRadius double
	 * @param divisionNumber int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ConeFrom_to_radius_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double aRadius, int divisionNumber) {
		JunOpenGL3dCompoundObject aCone = new JunOpenGL3dCompoundObject();
		Jun3dCircle fromCircle = new Jun3dCircle(fromPoint, aRadius, toPoint.to_(fromPoint).normalUnitVector());
		Jun3dPoint[] fromPoints = fromCircle.trackPointsBy_((int) Math.round(360.0 / divisionNumber));
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(fromPoints);
		aCone.add_(aPolygon);
		for (int i = 0; i < fromPoints.length - 1; i++) {
			Jun3dPoint p1 = fromPoints[i];
			Jun3dPoint p2 = fromPoints[i + 1];
			Jun3dPoint[] points = new Jun3dPoint[] { p1, new Jun3dPoint(toPoint), p2 };
			Jun3dPoint[] vectors = new Jun3dPoint[] { fromPoint.to_(p1).normalUnitVector(), fromPoint.to_(toPoint).normalUnitVector(), fromPoint.to_(p2).normalUnitVector() };
			aPolygon = new JunOpenGL3dPolygon(points);
			aPolygon.normalVectors_(vectors);
			aCone.add_(aPolygon);
		}
		aCone.flushAllPaints();
		aCone.paint_(DefaultPaint());

		return aCone;
	}

	/**
	 * Typical object - cone.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ConeFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return new JunOpenGL3dCone(toPoint, fromPoint, widthFactor / 2, 10);
	}

	/**
	 * Typical object - xUnitCone.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject XUnitCone() {
		return Cone().transform_(Jun3dTransformation.Scale_(new Jun3dPoint(0.5, 0.5, 0.5)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
	}
}
