package jp.co.sra.jun.opengl.objects.typical;

import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsPie class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsPie.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsPie extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return ChunkOfPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, 1.0d);
	}

	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		StBlockClosure rotationBlock = new StBlockClosure() {
			public Object value_value_(Object anObject1, Object anObject2) {
				Jun3dPoint p = (Jun3dPoint) anObject1;
				double t = ((Number) anObject2).doubleValue();
				double x = (p.x() * Math.cos(t)) - (p.y() * Math.sin(t));
				double y = (p.x() * Math.sin(t)) + (p.y() * Math.cos(t));
				if (Math.abs(x) < JunGeometry.ACCURACY) {
					x = 0.0d;
				}
				if (Math.abs(y) < JunGeometry.ACCURACY) {
					y = 0.0d;
				}
				return new Jun3dPoint(x, y, 0.0d);
			}
		};

		Jun3dPoint standardPoint = new Jun3dPoint(radius, 0.0d, 0.0d);
		Vector points = new Vector();
		boolean extraFlag = false;
		if (byDegree > 0) {
			for (double theta = fromDegree; theta <= toDegree; theta += byDegree) {
				points.addElement(rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta))));
				extraFlag = (theta == toDegree);
			}
		} else {
			for (double theta = fromDegree; theta >= toDegree; theta += byDegree) {
				points.addElement(rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta))));
				extraFlag = (theta == toDegree);
			}
		}
		if (extraFlag == false) {
			points.addElement(rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(toDegree))));
		}
		points.addElement(new Jun3dPoint(0.0d, 0.0d, 0.0d));
		JunOpenGL3dPolygon aPie = new JunOpenGL3dPolygon(points);
		aPie.flushAllPaints();
		aPie.paint_(DefaultPaint());

		return aPie;
	}

	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		JunOpenGL3dPolygon pie1 = (JunOpenGL3dPolygon) ChunkOfPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
		JunOpenGL3dPolygon pie2 = (JunOpenGL3dPolygon) Jun3dTransformation.Align_with_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, thickness)).applyTo_(pie1);
		JunOpenGL3dCompoundObject thickPie = new JunOpenGL3dCompoundObject(pie2);
		Jun3dPoint[] firstPoints = null;
		Jun3dPoint[] points = null;
		Jun3dPoint[] vertexes1 = pie1.vertexes();
		Jun3dPoint[] vertexes2 = pie2.vertexes();
		int size = vertexes1.length;
		for (int i = 0; i < size; i++) {
			if (firstPoints == null) {
				firstPoints = points = new Jun3dPoint[] { vertexes1[i], vertexes2[i] };
			} else {
				thickPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { vertexes1[i], vertexes2[i], points[1], points[0] }));
				points = new Jun3dPoint[] { vertexes1[i], vertexes2[i] };
			}
		}
		thickPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { firstPoints[0], firstPoints[1], points[1], points[0] }));
		thickPie.add_(pie1.reversed());
		thickPie.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		thickPie.paint_(DefaultPaint());

		return thickPie;
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return PieFrom_to_by_radius_(fromDegree, toDegree, byDegree, 1.0d);
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		if (Math.abs(fromDegree - toDegree) > 180) {
			return SlicedPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
		} else {
			return ChunkOfPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
		}
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		if (Math.abs(fromDegree - toDegree) > 180) {
			return SlicedPieFrom_to_by_radius_thickness_(fromDegree, toDegree, byDegree, radius, thickness);
		} else {
			return ChunkOfPieFrom_to_by_radius_thickness_(fromDegree, toDegree, byDegree, radius, thickness);
		}
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return SlicedPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, 1.0d);
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		StBlockClosure rotationBlock = new StBlockClosure() {
			public Object value_value_(Object anObject1, Object anObject2) {
				Jun3dPoint p = (Jun3dPoint) anObject1;
				double t = ((Number) anObject2).doubleValue();
				double x = (p.x() * Math.cos(t)) - (p.y() * Math.sin(t));
				double y = (p.x() * Math.sin(t)) + (p.y() * Math.cos(t));
				if (Math.abs(x) < JunGeometry.ACCURACY) {
					x = 0.0d;
				}
				if (Math.abs(y) < JunGeometry.ACCURACY) {
					y = 0.0d;
				}
				return new Jun3dPoint(x, y, 0.0d);
			}
		};

		JunOpenGL3dCompoundObject aPie = new JunOpenGL3dCompoundObject();
		Jun3dPoint standardPoint = new Jun3dPoint(radius, 0.0d, 0.0d);
		Jun3dPoint lastPoint = (Jun3dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(fromDegree)));
		Jun3dPoint point = null;
		if (byDegree > 0) {
			for (double theta = fromDegree + byDegree; theta <= toDegree; theta += byDegree) {
				point = (Jun3dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta)));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { lastPoint, point, new Jun3dPoint(0, 0, 0) }));
				lastPoint = (theta == toDegree) ? null : point;
			}
		} else {
			for (double theta = fromDegree + byDegree; theta >= toDegree; theta += byDegree) {
				point = (Jun3dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta)));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { lastPoint, point, new Jun3dPoint(0, 0, 0) }));
				lastPoint = (theta == toDegree) ? null : point;
			}
		}

		if (lastPoint != null) {
			point = (Jun3dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(toDegree)));
			aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { lastPoint, point, new Jun3dPoint(0, 0, 0) }));
		}

		aPie.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		aPie.paint_(DefaultPaint());

		return aPie;
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		StBlockClosure rotationBlock = new StBlockClosure() {
			public Object value_value_(Object anObject1, Object anObject2) {
				Jun3dPoint p = (Jun3dPoint) anObject1;
				double t = ((Number) anObject2).doubleValue();
				double x = (p.x() * Math.cos(t)) - (p.y() * Math.sin(t));
				double y = (p.x() * Math.sin(t)) + (p.y() * Math.cos(t));
				if (Math.abs(x) < JunGeometry.ACCURACY) {
					x = 0.0d;
				}
				if (Math.abs(y) < JunGeometry.ACCURACY) {
					y = 0.0d;
				}
				return new Jun2dPoint(x, y);
			}
		};

		JunOpenGL3dCompoundObject aPie = new JunOpenGL3dCompoundObject();
		Jun3dPoint standardPoint = new Jun3dPoint(radius, 0.0d, 0.0d);
		Jun2dPoint firstPoint = (Jun2dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(fromDegree)));
		Jun2dPoint lastPoint = firstPoint;
		Jun2dPoint point = null;
		boolean extraDegreeExists = false;
		if (byDegree > 0) {
			for (double theta = fromDegree + byDegree; theta < toDegree; theta += byDegree) {
				point = (Jun2dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta)));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(point, 0), new Jun3dPoint(lastPoint, 0) }));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, thickness), new Jun3dPoint(point, thickness), new Jun3dPoint(0, 0, thickness) }));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, 0), new Jun3dPoint(point, 0), new Jun3dPoint(point, thickness), new Jun3dPoint(lastPoint, thickness) }, new Jun3dPoint[] {
						new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(lastPoint, 0)).normalUnitVector(),
						new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(point, 0)).normalUnitVector(),
						new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(point, thickness)).normalUnitVector(),
						new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(lastPoint, thickness)).normalUnitVector() }));
				lastPoint = point;
				extraDegreeExists = (theta == toDegree);
			}
		} else {
			for (double theta = fromDegree + byDegree; theta > toDegree; theta += byDegree) {
				point = (Jun2dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(theta)));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(point, 0), new Jun3dPoint(lastPoint, 0) }));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, thickness), new Jun3dPoint(point, thickness), new Jun3dPoint(0, 0, thickness) }));
				aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, 0), new Jun3dPoint(point, 0), new Jun3dPoint(point, thickness), new Jun3dPoint(lastPoint, thickness) }, new Jun3dPoint[] {
						new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(lastPoint, 0)).normalUnitVector(),
						new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(point, 0)).normalUnitVector(),
						new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(point, thickness)).normalUnitVector(),
						new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(lastPoint, thickness)).normalUnitVector() }));
				lastPoint = point;
				extraDegreeExists = (theta == toDegree);
			}
		}

		if (extraDegreeExists == false) {
			point = (Jun2dPoint) rotationBlock.value_value_(standardPoint, new Double(JunAngle._DegreesToRadians(toDegree)));
			aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(point, 0), new Jun3dPoint(lastPoint, 0) }));
			aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, thickness), new Jun3dPoint(point, thickness), new Jun3dPoint(0, 0, thickness) }));
			aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(lastPoint, 0), new Jun3dPoint(point, 0), new Jun3dPoint(point, thickness), new Jun3dPoint(lastPoint, thickness) }, new Jun3dPoint[] {
					new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(lastPoint, 0)).normalUnitVector(),
					new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(point, 0)).normalUnitVector(),
					new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(point, thickness)).normalUnitVector(),
					new Jun3dPoint(0, 0, thickness).to_(new Jun3dPoint(lastPoint, thickness)).normalUnitVector() }));
			lastPoint = point;
		}

		aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(firstPoint, 0), new Jun3dPoint(firstPoint, thickness), new Jun3dPoint(0, 0, thickness), new Jun3dPoint(0, 0, 0) }));
		aPie.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, thickness), new Jun3dPoint(lastPoint, thickness), new Jun3dPoint(lastPoint, 0) }));

		aPie.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		aPie.paint_(DefaultPaint());

		return aPie;
	}
}
