package jp.co.sra.jun.opengl.objects.typical;

import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsShpere class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsShpere.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsShpere extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - globe
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe() {
		JunOpenGL3dObject globe = Sphere();
		globe.name_("globe");

		return globe;
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_(double degrees) {
		JunOpenGL3dObject globe = Sphere_(degrees);
		globe.name_("globe");
		return globe;
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_radius_(double degrees, double radius) {
		JunOpenGL3dObject globe = Sphere_radius_(degrees, radius);
		globe.name_("globe");
		return globe;
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_radius_center_(double degrees, double radius, Jun3dPoint center) {
		JunOpenGL3dObject globe = Sphere_radius_center_(degrees, radius, center);
		globe.name_("globe");
		return globe;
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere() {
		JunOpenGL3dObject hemisphere = Sphere_radius_longitude_latitude_(10, 1, 180, 180);
		hemisphere.name_("hemisphere");
		return hemisphere;
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_(double degrees) {
		JunOpenGL3dObject hemisphere = Sphere_radius_longitude_latitude_(degrees, 1, 180, 180);
		hemisphere.name_("hemisphere");
		return hemisphere;
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_redius_(double degrees, double radius) {
		JunOpenGL3dObject hemisphere = Sphere_radius_longitude_latitude_(degrees, radius, 180, 180);
		hemisphere.name_("hemisphere");
		return hemisphere;
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_redius_center_(double degrees, double radius, Jun3dPoint center) {
		JunOpenGL3dObject hemisphere = Sphere_radius_longitude_latitude_(degrees, radius, 180, 180);
		hemisphere.transform_(Jun3dTransformation.Align_with_(new Jun3dPoint(0, 0, 0), center));
		hemisphere.name_("hemisphere");
		return hemisphere;
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere() {
		return (JunOpenGL3dObject) XyPointsAndSphere_radius_longitude_latitude_(10, 1, 360, 180)[1];
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_(double degrees) {
		return (JunOpenGL3dObject) XyPointsAndSphere_radius_longitude_latitude_(degrees, 1, 360, 180)[1];
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_(double degrees, double radius) {
		return (JunOpenGL3dObject) XyPointsAndSphere_radius_longitude_latitude_(degrees, radius, 360, 180)[1];
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_center_(double degrees, double radius, Jun3dPoint center) {
		return Jun3dTransformation.Align_with_(Jun3dPoint.Zero(), center).applyTo_(Sphere_radius_(degrees, radius));
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param longitude double
	 * @param latitude double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_longitude_latitude_(double degrees, double radius, double longitude, double latitude) {
		return (JunOpenGL3dObject) XyPointsAndSphere_radius_longitude_latitude_(degrees, radius, longitude, latitude)[1];
	}

	/**
	 * Answer the array which includes a collection of points and a sphere.
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param longitude double
	 * @param latitude double
	 * @return java.lang.Object[]
	 * @category Typical objects sphere
	 */
	public static Object[] XyPointsAndSphere_radius_longitude_latitude_(double degrees, double radius, double longitude, double latitude) {
		final double theDegrees = Math.max(1, Math.min(degrees, 90));
		final double theRadius = Math.max(0, radius);
		final double theLongitude = Math.max(1, Math.min(longitude, 360));
		final double theLatitude = Math.max(1, Math.min(latitude, 180));
		StBlockClosure xyzBlock = new StBlockClosure() {
			public Object value_value_value_(Object r, Object pd, Object td) {
				double phi = JunAngle._DegreesToRadians(((Double) pd).doubleValue());
				double theta = JunAngle._DegreesToRadians(((Double) td).doubleValue());
				double rd = ((Double) r).doubleValue();
				double x = rd * Math.sin(theta) * Math.cos(phi);
				double y = rd * Math.sin(theta) * Math.sin(phi);
				double z = rd * Math.cos(theta);
				if (Math.abs(x - 0.0d) < JunGeometry.ACCURACY) {
					x = 0.0d;
				}
				if (Math.abs(y - 0.0d) < JunGeometry.ACCURACY) {
					y = 0.0d;
				}
				if (Math.abs(z - 0.0d) < JunGeometry.ACCURACY) {
					z = 0.0d;
				}
				return new Jun3dPoint(x, y, z);
			}
		};
		StBlockClosure xyBlock = new StBlockClosure() {
			public Object value_value_(Object phi, Object theta) {
				return new Jun2dPoint(((Double) phi).doubleValue() / theLongitude, ((Double) theta).doubleValue() / theLatitude);
			}
		};

		int numberOfPolygons = (int) Math.round(theLongitude / theDegrees * (theLatitude / theDegrees));
		Vector[] pointCollections = new Vector[numberOfPolygons];
		int indexOfPointCollections = 0;
		Vector xyCollection = new Vector(numberOfPolygons * 4);
		for (double phi = 0; phi <= (theLongitude - theDegrees); phi += theDegrees) {
			for (double theta = 0; theta <= (theLatitude - theDegrees); theta += theDegrees) {
				Vector pointCollection = new Vector(4);
				Jun3dPoint currentPoint = (Jun3dPoint) xyzBlock.value_value_value_(new Double(theRadius), new Double(phi), new Double(theta));
				pointCollection.addElement(currentPoint);
				xyCollection.addElement(xyBlock.value_value_(new Double(phi), new Double(theta)));
				Jun3dPoint firstPoint = currentPoint;
				Jun3dPoint previousPoint = currentPoint;
				currentPoint = (Jun3dPoint) xyzBlock.value_value_value_(new Double(theRadius), new Double(phi), new Double(theta + theDegrees));
				if (!currentPoint.equals(previousPoint)) {
					pointCollection.addElement(currentPoint);
					xyCollection.addElement(xyBlock.value_value_(new Double(phi), new Double(theta + theDegrees)));
				}
				previousPoint = currentPoint;
				currentPoint = (Jun3dPoint) xyzBlock.value_value_value_(new Double(theRadius), new Double(phi + theDegrees), new Double(theta + theDegrees));
				if (!currentPoint.equals(previousPoint) && !currentPoint.equals(firstPoint)) {
					pointCollection.addElement(currentPoint);
					xyCollection.addElement(xyBlock.value_value_(new Double(phi + theDegrees), new Double(theta + theDegrees)));
				}
				previousPoint = currentPoint;
				currentPoint = (Jun3dPoint) xyzBlock.value_value_value_(new Double(theRadius), new Double(phi + theDegrees), new Double(theta));
				if (!currentPoint.equals(previousPoint) && !currentPoint.equals(firstPoint)) {
					pointCollection.addElement(currentPoint);
					xyCollection.addElement(xyBlock.value_value_(new Double(phi + theDegrees), new Double(theta)));
				}
				previousPoint = currentPoint;
				pointCollections[indexOfPointCollections++] = pointCollection;
			}
		}

		JunOpenGL3dCompoundObject aSphere = new JunOpenGL3dCompoundObject();
		aSphere.name_("sphere");
		for (int i = 0; i < indexOfPointCollections; i++) {
			JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(pointCollections[i]);
			Jun3dPoint[] normalVectors = new Jun3dPoint[pointCollections[i].size()];
			for (int j = 0; j < normalVectors.length; j++) {
				normalVectors[j] = new Jun3dPoint(0, 0, 0).to_((Jun3dPoint) pointCollections[i].get(j)).normalUnitVector();
			}
			polygon.normalVectors_(normalVectors);
			aSphere.add_(polygon);
		}

		aSphere.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		aSphere.paint_(DefaultPaint());

		Object[] result = { xyCollection, aSphere };
		return result;
	}
}
