package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StInterval;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dPolygonalBoundary;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.boundaries.JunBorderGenerator;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.font.JunFontModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsText class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsText.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsText extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects misc - characterN
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject CharacterN() {
		JunOpenGL3dObject aCube;
		JunOpenGL3dCompoundObject characterN;

		characterN = new JunOpenGL3dCompoundObject();
		aCube = JunOpenGL3dObject.Cube().scaledBy_(new Jun3dPoint(0.5, 0.25, 1)).translatedBy_(new Jun3dPoint(0, -0.75, 0));
		characterN.add_(aCube);
		aCube = JunOpenGL3dObject.Cube().scaledBy_(new Jun3dPoint(0.5, 0.25, 1)).translatedBy_(new Jun3dPoint(0, 0.75, 0));
		characterN.add_(aCube);
		aCube = JunOpenGL3dObject.Cube().scaledBy_(new Jun3dPoint(0.5, 0.25, 1)).transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(45)));
		characterN.add_(aCube);
		characterN.name_("character N");

		// characterN do: [:each | each paint: nil].
		for (int i = 0; i < characterN.components().length; i++) {
			characterN.components()[i].paint_((Color) null);
		}
		characterN.paint_(DefaultPaint());

		return characterN;
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_(StComposedText aComposedText) {
		return Text2d_weight_(aComposedText, 0.5);
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_(String aString) {
		return Text2d_weight_font_(aString, 0.5, JunFontModel.TextStyle());
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aString java.lang.String
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_font_(String aString, Font aFont) {
		return Text2d_weight_font_(aString, 0.5, aFont);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_(String aString) {
		return Text2d_weight_(aString, 0.5);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_(String aString, double aNumber) {
		return Text2d_weight_(new StComposedText(aString), aNumber);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_font_(String aString, double aNumber, Font aFont) {
		return Text2d_weight_(new StComposedText(aString, aFont), aNumber);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_(StComposedText aComposedText, double aNumber) {
		double weight = Math.max(0.1, Math.min(aNumber, 0.9));
		Dimension extent = aComposedText.extent();
		final StImage image = new StImage(extent.width + 2, extent.height + 2);

		Graphics graphics = null;
		try {
			graphics = image.image().getGraphics();
			graphics.setColor(Color.black);
			graphics.fillRect(0, 0, image.width(), image.height());
			graphics.setColor(Color.white);

			aComposedText.displayOn_at_(graphics, new Point(1, 1));

			image.image().flush();
		} finally {
			if (graphics != null) {
				graphics.dispose();
				graphics = null;
			}
		}

		StBlockClosure evaluationBlock = new StBlockClosure() {
			public Object value_value_(Object x, Object y) {
				Color color = image.valueAtPoint_(new Point(((Number) x).intValue(), (image.height() - ((Number) y).intValue())));
				float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
				return new Float(hsb[2]);
			}
		};

		Jun2dPolygonalBoundary polygonalBoundary = JunBorderGenerator.PolygonalBoundaryWith_min_xInterval_yInterval_interim_(evaluationBlock, 1 - weight, new StInterval(0, image.width() - 1), new StInterval(1, image.height() - 1), new StBlockClosure());
		JunOpenGL3dObject object = polygonalBoundary.asJunOpenGL3dObject();

		Rectangle textBounds = aComposedText.bounds();
		Jun3dBoundingBox box = Jun3dBoundingBox.Origin_extent_(new Jun3dPoint(textBounds.x, textBounds.y, 0), new Jun3dPoint(textBounds.width, textBounds.height, 0));
		JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] {
				box.origin(),
				new Jun3dPoint(box.corner().x(), box.origin().y(), box.origin().z()),
				new Jun3dPoint(box.corner().x(), box.corner().y(), box.origin().z()),
				new Jun3dPoint(box.origin().x(), box.corner().y(), box.origin().z()) });
		polygon.halftone_(0);
		object = new JunOpenGL3dCompoundObject(object, polygon);

		object.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		object.paint_(DefaultPaint());

		return object;
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_(String aString) {
		return Text3d_weight_(aString, 0.5);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_(String aString, double aNumber) {
		return Text3d_weight_(new StComposedText(aString), aNumber);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_font_(String aString, double aNumber, Font aFont) {
		return Text3d_weight_(new StComposedText(aString, aFont), aNumber);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_(StComposedText aComposedText, double aNumber) {
		double weight = Math.max(0.1, Math.min(aNumber, 0.9));
		Dimension extent = aComposedText.extent();
		final StImage image = new StImage(extent.width + 2, extent.height + 2);

		Graphics graphics = null;
		try {
			graphics = image.image().getGraphics();
			graphics.setColor(Color.black);
			graphics.fillRect(0, 0, image.width(), image.height());
			graphics.setColor(Color.white);

			aComposedText.displayOn_at_(graphics, new Point(1, 1));

			image.image().flush();
		} finally {
			if (graphics != null) {
				graphics.dispose();
				graphics = null;
			}
		}

		StBlockClosure evaluationBlock = new StBlockClosure() {
			public Object value_value_value_(Object objX, Object objY, Object objZ) {
				int x = ((Number) objX).intValue();
				int y = ((Number) objY).intValue();
				int z = ((Number) objZ).intValue();
				Color color = image.valueAtPoint_(new Point(x, image.height() - y));
				float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
				double result = 1 - hsb[2];
				result = Math.sqrt((result * result) + (z * z));
				return new Double(result);
			}
		};

		Jun3dPolygon[] polygons = JunBorderGenerator.ContourPolygonsFrom_at_sign_xInterval_yInterval_zInterval_interim_(evaluationBlock, weight, -1, new StInterval(0, image.width() - 1), new StInterval(1, image.height()), new StInterval(-1, 1),
				new StBlockClosure());
		JunOpenGL3dCompoundObject object = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < polygons.length; i++) {
			JunOpenGL3dObject each = polygons[i].asJunOpenGL3dObject();
			object.add_(each);
		}

		Rectangle textBounds = aComposedText.bounds();
		Jun3dBoundingBox box = Jun3dBoundingBox.Origin_extent_(new Jun3dPoint(textBounds.x, textBounds.y, 0), new Jun3dPoint(textBounds.width, textBounds.height, 0));
		JunOpenGL3dPolygon polygon = new JunOpenGL3dPolygon(new Jun3dPoint[] {
				box.origin(),
				new Jun3dPoint(box.corner().x(), box.origin().y(), box.origin().z()),
				new Jun3dPoint(box.corner().x(), box.corner().y(), box.origin().z()),
				new Jun3dPoint(box.origin().x(), box.corner().y(), box.origin().z()) });
		polygon.halftone_(0);
		object = new JunOpenGL3dCompoundObject(object, polygon);

		object.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		object.paint_(DefaultPaint());

		return object;
	}
}
