package jp.co.sra.jun.opengl.picking;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLObjectPickerTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLObjectPickerTestExamples.java,v 8.11 2008/02/20 06:32:48 nisinaka Exp $
 */
public class JunOpenGLObjectPickerTestExamples extends JunTestExamples {

	/**
	 * ManualExample1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1() {
		JunOpenGL3dObject aBox = JunOpenGL3dObject.Box();
		aBox.paint_(Color.green);
		JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Globe();
		aGlobe.paint_(Color.red);
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();
		aCompoundObject.add_(aBox);
		aCompoundObject.add_(aGlobe);
		JunOpenGLDisplayModel aDisplayModel = new JunOpenGLDisplayModel(aCompoundObject);
		aDisplayModel.open();

		Jun2dPoint aPoint = new Jun2dPoint(0, 0);
		JunOpenGLProjection aProjection = aDisplayModel.displayProjector().projection();
		JunOpenGL3dObject aPickedObject = JunOpenGLObjectPicker.PickObjectAt_fromCompound_projection_(aPoint, aCompoundObject, aProjection);
		(new JunOpenGLDisplayModel(aPickedObject)).open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLObjectPickerTestExamples();
	}

}
