package jp.co.sra.jun.opengl.roughsketch;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;

/**
 * JunOpenGLRoughSketchViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2005/10/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun536 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRoughSketchViewSwing.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRoughSketchViewSwing extends JunOpenGLDisplayViewSwing implements JunOpenGLRoughSketchView {

	protected JunButtonViewSwing pencilButtonView;

	/**
	 * Create a new instance of JunOpenGLRoughSketchViewSwing and initialize it.
	 *
	 * @param aRoughSketch jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketch
	 * @category Instance creation
	 */
	public JunOpenGLRoughSketchViewSwing(JunOpenGLRoughSketch aRoughSketch) {
		super(aRoughSketch);
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		super.buildComponent();
		this.add(this.pencilButtonView(), WindowSpecLayout.Position(0f, 1, 0f, 58, 0f, 19, 0f, 76));
	}

	/**
	 * Answer my model as JunOpenGLRoughSketch.
	 * 
	 * @return jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketch
	 * @see jp.co.sra.jun.opengl.roughsketch.JunOpenGLRoughSketchView#getRoughSketch()
	 * @category model accessing
	 */
	public JunOpenGLRoughSketch getRoughSketch() {
		return (JunOpenGLRoughSketch) this.model();
	}

	/**
	 * Answer my default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunOpenGLRoughSketchController();
	}

	/**
	 * Answer the pencil button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category user interface 
	 */
	protected JunButtonViewSwing pencilButtonView() {
		if (pencilButtonView == null) {
			pencilButtonView = new JunButtonViewSwing(this.getRoughSketch().pencilButton());
		}
		return pencilButtonView;
	}

}
