package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;

import jp.co.sra.smalltalk.DependentListener;

/**
 * JunOpenGLDrawable interface
 * 
 *  @author    nisinaka
 *  @created   2007/08/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDrawable.java,v 8.4 2008/02/20 06:32:49 nisinaka Exp $
 */
public interface JunOpenGLDrawable extends DependentListener {

	/**
	 * Answer my current OpenGL interface.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLInterface
	 * @category accessing 
	 */
	public JunOpenGLInterface getOpenGLInterface();

	/**
	 * Answer my current size.
	 * 
	 * @return java.awt.Dimension
	 * @category accessing
	 */
	public Dimension getSize();

	/**
	 * Answer my current background color.
	 * 
	 * @return java.awt.Color
	 * @category accessing
	 */
	public Color getBackgroundColor();

	/**
	 * Set my new renderer.
	 * 
	 * @param anOpenGLRenderer jp.co.sra.jun.opengl.support.JunOpenGLRenderer
	 * @category accessing
	 */
	public void setRenderer(JunOpenGLRenderer anOpenGLRenderer);

	/**
	 * Convert to a component.
	 * 
	 * @return java.awt.Component
	 * @category converting
	 */
	public Component toComponent();

	/**
	 * Render the receiver on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext);

	/**
	 * Display the entire contents again.
	 * 
	 * @category displaying
	 */
	public void redisplay();

	/**
	 * Display the entire contents again immediately.
	 * 
	 * @category displaying
	 */
	public void redisplayImmediately();

}
