package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.lights.JunOpenGLAmbientLight;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.lights.JunOpenGLParallelLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;

/**
 * JunOpenGLRenderingContextTestExamples class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/04/07 (MATSUDA Ryouichi)
 *  @updated   2007/08/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRenderingContextTestExamples.java,v 8.14 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRenderingContextTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.paint_(Color.pink);

		Map projection = new HashMap();
		projection.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projection.put($("eyePoint"), new Jun3dPoint(9, 5, 7));
		projection.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projection.put($("zoomHeight"), new Double(4));
		projection.put($("viewFactor"), new Double(10));
		projection.put($("presentation"), $("solidPresentation"));
		projection.put($("shading"), $("smoothShading"));

		JunOpenGLDisplayModel renderer = new JunOpenGLDisplayModel(aCube) {
			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		renderer.projectionTable_(projection);

		Show(renderer, "Example");

		return true;
	}

	/**
	 * ManualExample1a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				renderingContext.paint_(Color.red);
				aProjector.projectOn_(renderingContext);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample1a");

		return true;
	}

	/**
	 * ManualExample1b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				anObject.paint_(Color.red);
				aProjector.projectOn_(renderingContext);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample1b");

		return true;
	}

	/**
	 * ManualExample2a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
				JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
				aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
				renderingContext.texture_(aTexture);
				renderingContext.enableTexture2d();
				aProjector.projectOn_(renderingContext);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample2a");

		return true;
	}

	/**
	 * ManualExample2b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
				JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
				aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0), new Jun2dPoint(0.0, 1.0) });
				aProjector.projectOn_(renderingContext);
				anObject.texture_(aTexture);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample2b");

		return true;
	}

	/**
	 * ManualExample3a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				JunOpenGLStipple aStipple = JunOpenGLStipple.Halftone();
				renderingContext.polygonStipple_(aStipple);
				renderingContext.enablePolygonStipple();
				aProjector.projectOn_(renderingContext);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample3a");

		return true;
	}

	/**
	 * ManualExample3b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.clear();
				JunOpenGLStipple aStipple = JunOpenGLStipple.Halftone();
				anObject.stipple_(aStipple);
				aProjector.projectOn_(renderingContext);
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample3b");

		return true;
	}

	/**
	 * ManualExample4a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample4a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGLParallelLight aLight = JunOpenGLParallelLight.At3dPoint_color_(new Jun3dPoint(0, 0, 10), Color.white);
				aProjector.addLight_(aLight);
				JunOpenGL3dObject anObject = JunOpenGL3dObject.Sphere();
				anObject.paint_(Color.red);
				renderingContext.clear();
				renderingContext.materialSpecular_(Color.green);
				renderingContext.materialShininess_(2.0f);
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample4a");

		return true;
	}

	/**
	 * ManualExample4b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample4b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGLParallelLight aLight = JunOpenGLParallelLight.At3dPoint_color_(new Jun3dPoint(0, 0, 10), Color.white);
				aProjector.addLight_(aLight);
				JunOpenGL3dObject anObject = JunOpenGL3dObject.Sphere();
				anObject.paint_(Color.red);
				renderingContext.clear();
				renderingContext.materialEmission_(Color.blue);
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample4b");

		return true;
	}

	/**
	 * ManualExample5a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample5a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjection aProjection = JunOpenGLProjection.Default();
				aProjection.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjection.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjection.upVector_(new Jun3dPoint(0, 0, 1));
				aProjection.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.red);
				renderingContext.clear();
				renderingContext.perspective_(aProjection.asPerspectiveProjection());
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample5a");

		return true;
	}

	/**
	 * ManualExample5b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample5b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.red);
				renderingContext.clear();
				aProjector.parallelProjection();
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample5b");

		return true;
	}

	/**
	 * ManualExample6a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample6a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				renderingContext.clear();
				aProjector.projectOn_(renderingContext);
				renderingContext.paint_(Color.red);
				renderingContext.displayPolygon_(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample6a");

		return true;
	}

	/**
	 * ManualExample6b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample6b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.red);
				renderingContext.clear();
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample6b");

		return true;
	}

	/**
	 * ManualExample7a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample7a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.lightGray);
				renderingContext.clear();
				aProjector.projectOn_(renderingContext);
				renderingContext.lightAmbientColor_alpha_twoSide_(Color.red, 1.0f, false);
				renderingContext.enableLighting();
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample7a");

		return true;
	}

	/**
	 * ManualExample7b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample7b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.lightGray);
				renderingContext.clear();
				JunOpenGLLight aLight = JunOpenGLAmbientLight.Color_(Color.red);
				aProjector.addLight_(aLight);
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample7b");

		return true;
	}

	/**
	 * ManualExample8a:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample8a() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.lightGray);
				renderingContext.clear();
				aProjector.projectOn_(renderingContext);
				int index = renderingContext.getLightIndex();
				renderingContext.lightIndex_position_parallel_color_alpha_(index, new Jun3dPoint(0.0, 0.0, 5.0), true, Color.red, 1.0f);
				renderingContext.enableLightIndex_(index);
				renderingContext.enableLighting();
				anObject.renderOn_(renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample8a");

		return true;
	}

	/**
	 * ManualExample8b:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample8b() {
		JunOpenGLRenderer renderer = new JunOpenGLRenderer() {
			public void renderOn_(JunOpenGLRenderingContext renderingContext) {
				JunOpenGLProjector aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(3, 3, 3));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0.5));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.viewFactor_(10);
				JunOpenGL3dObject anObject = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
				anObject.paint_(Color.lightGray);
				renderingContext.clear();
				JunOpenGLLight aLight = JunOpenGLParallelLight.At3dPoint_color_(new Jun3dPoint(0.0d, 0.0d, 5.0d), Color.red);
				aProjector.addLight_(aLight);
				aProjector.project_on_(anObject, renderingContext);
				renderingContext.flush();
			}

			public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
				SuperimposeOn(aGraphics, aDrawable);
			}
		};
		Show(renderer, "ManualExample8b");

		return true;
	}

	/**
	 * Show the components.
	 * 
	 * @param aJunGLCanvas jp.co.sra.jun.opengl.support.JunGLCanvas
	 * @param aJunGLJPanel jp.co.sra.jun.opengl.support.JunGLJPanel
	 * @param aJOGLCanvas jp.co.sra.jun.opengl.support.JOGLCanvas
	 * @param aJOGLJPanel jp.co.sra.jun.opengl.support.JOGLJPanel
	 * @param titleString java.lang.String
	 * @category Utilities
	 */
	protected static void Show(JunOpenGLRenderer anOpenGLRenderer, String titleString) {
		JunOpenGLDrawable aJunGLCanvas = new JunGLCanvas(anOpenGLRenderer);
		JunOpenGLDrawable aJunGLJPanel = new JunGLJPanel(anOpenGLRenderer);
		JunOpenGLDrawable aJOGLCanvas = null;
		if (JunOpenGLResource.GetJOGLCanvasClass() != null) {
			try {
				aJOGLCanvas = (JunOpenGLDrawable) JunOpenGLResource.GetJOGLCanvasClass().newInstance();
				aJOGLCanvas.setRenderer(anOpenGLRenderer);
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
		}
		JunOpenGLDrawable aJOGLJPanel = null;
		if (JunOpenGLResource.GetJOGLJPanelClass() != null) {
			try {
				aJOGLJPanel = (JunOpenGLDrawable) JunOpenGLResource.GetJOGLJPanelClass().newInstance();
			} catch (InstantiationException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			}
			aJOGLJPanel.setRenderer(anOpenGLRenderer);
		}

		Panel panel = new Panel();
		panel.setLayout(new WindowSpecLayout());
		panel.add(aJunGLCanvas.toComponent(), WindowSpecLayout.Position(0f, 0, 0f, 0, 0.5f, 0, 0.5f, 0));
		panel.add(aJunGLJPanel.toComponent(), WindowSpecLayout.Position(0.5f, 0, 0f, 0, 1f, 0, 0.5f, 0));
		if (aJOGLCanvas != null) {
			panel.add(aJOGLCanvas.toComponent(), WindowSpecLayout.Position(0f, 0, 0.5f, 0, 0.5f, 0, 1f, 0));
		}
		if (aJOGLJPanel != null) {
			panel.add(aJOGLJPanel.toComponent(), WindowSpecLayout.Position(0.5f, 0, 0.5f, 0, 1f, 0, 1f, 0));
		}

		Frame frame = new Frame(titleString);
		frame.add(panel);
		frame.setSize(600, 600);
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		StApplicationModel._ShowAtMousePoint(frame);
	}

	/**
	 * Superimpose the class name of the drawable on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @param aDrawable jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @category Utilities
	 */
	protected static void SuperimposeOn(Graphics aGraphics, JunOpenGLDrawable aDrawable) {
		String name = aDrawable.getClass().getName();
		name = name.substring(name.lastIndexOf('.') + 1);
		StComposedText text = new StComposedText(name);
		int x = (aDrawable.toComponent().getWidth() - text.width()) / 2;
		int y = text.height();
		text.displayOn_at_(aGraphics, new Point(x, y));
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		System.out.println("JOGL is available : " + JunOpenGLResource.IsJOGLAvailable());
		System.out.println("JOGL is specified to be used : " + JunOpenGLResource.UseJOGL());
		new JunOpenGLRenderingContextTestExamples();
	}

}
