package jp.co.sra.jun.opengl.texture;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLStippleTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/19 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStippleTestExamples.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunOpenGLStippleTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGLStipple aStipple = JunOpenGLStipple.Halftone_(0.5);
		Jun3dPoint[] points = new Jun3dPoint[4];
		points[0] = new Jun3dPoint(0.0, 0.0, 1.0);
		points[1] = new Jun3dPoint(1.0, 0.0, 1.0);
		points[2] = new Jun3dPoint(1.0, 1.0, 1.0);
		points[3] = new Jun3dPoint(0.0, 1.0, 1.0);

		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(points);
		aPolygon.name_("example");
		aPolygon.paint_(Color.blue);
		aPolygon.stipple_(aStipple);
		aPolygon.show();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dPoint[] points = new Jun3dPoint[4];
		points[0] = new Jun3dPoint(0.0, 0.0, 1.0);
		points[1] = new Jun3dPoint(1.0, 0.0, 1.0);
		points[2] = new Jun3dPoint(1.0, 1.0, 1.0);
		points[3] = new Jun3dPoint(0.0, 1.0, 1.0);

		for (int each = 1; each < 9; each++) {
			JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(points);
			aPolygon.name_("example");
			aPolygon.paint_(Color.red);

			JunOpenGLStipple aStipple = JunOpenGLStipple.Halftone_(each / 8.0);
			System.out.print(each / 8.0);
			aPolygon.stipple_(aStipple);
			aPolygon.show();
		}

		return true;
	}

	/**
	 * ManualExample1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1() {
		JunOpenGL3dPolygon aPolygon;
		JunOpenGL3dObject aSphere;
		JunOpenGL3dCompoundObject aCompoundObject;

		aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 0.0d, 1.0d), new Jun3dPoint(1.0d, 1.0d, 1.0d), new Jun3dPoint(0.0d, 1.0d, 1.0d) });
		aPolygon.paint_(Color.red);
		aPolygon.halftone_(0.5f);
		aSphere = JunOpenGL3dObject.Sphere_radius_center_(15, 0.5, new Jun3dPoint(0.5, 0.5, 0.5));
		aSphere.paint_(Color.green);
		aCompoundObject = new JunOpenGL3dCompoundObject(aPolygon, aSphere);
		aCompoundObject.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGLStippleTestExamples();
	}

}
