package jp.co.sra.jun.system.dialog;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StView;

/**
 * JunPopUpDialogController class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun620 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPopUpDialogController.java,v 8.12 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunPopUpDialogController extends StController implements FocusListener {

	/**
	 * Remove references to objects that may refer to the receiver.
	 * Remove the listeners of the view here as well.
	 * 
	 * @see jp.co.sra.smalltalk.StObject#release()
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	public void release() {
		super.release();
		this.getPopUpDialogView()._focusedComponent().removeFocusListener(this);
	}

	/**
	 * Add myself as a listener of the view.
	 * 
	 * @param aView jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StController#release()
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	protected void buildListener(StView aView) {
		this.getPopUpDialogView()._focusedComponent().addFocusListener(this);
	}

	/**
	 * Answer my model as JunPopUpDialog.
	 * 
	 * @return jp.co.sra.jun.system.dialog.JunPopUpDialog
	 * @category model accessing
	 */
	public JunPopUpDialog getPopUpDialog() {
		return this.getPopUpDialogView().getPopUpDialog();
	}

	/**
	 * Answer my view as JunPopUpDialogView.
	 * 
	 * @return jp.co.sra.jun.system.dialog.JunPopUpDialogView
	 * @category view accessing
	 */
	public JunPopUpDialogView getPopUpDialogView() {
		return (JunPopUpDialogView) this.view();
	}

	/**
	 * Invoked when a component gains the keyboard focus.
	 * 
	 * @param e java.awt.event.FocusEvent
	 * @see java.awt.event.FocusListener#focusGained(java.awt.event.FocusEvent)
	 * @category events
	 */
	public void focusGained(FocusEvent e) {
		// do nothing
	}

	/**
	 * Invoked when a component loses the keyboard focus.
	 * 
	 * @param e java.awt.event.FocusEvent
	 * @see java.awt.event.FocusListener#focusLost(java.awt.event.FocusEvent)
	 * @category events
	 */
	public void focusLost(FocusEvent e) {
		this.getPopUpDialog().closeByClick();
	}

}
