package jp.co.sra.jun.system.support;

import java.awt.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.goodies.display.JunDisplayModel;

/**
 * JunSmallCompilerTestExamples class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   2003/05/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSmallCompilerTestExamples.java,v 8.10 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunSmallCompilerTestExamples extends JunTestExamples {

	/**
	 * Example_LongNumber: evaluate a long number.
	 * 
	 * @return boolean
	 */
	public static boolean Example_LongNumber() {
		Object longNumber = JunSmallCompiler.Evaluate_("2002112612345600000");
		System.out.println(longNumber);
		return (longNumber instanceof Long && ((Long) longNumber).longValue() == 2002112612345600000L);
	}

	/**
	 * Example for some constant values.
	 * 
	 * @return boolean
	 */
	public static boolean Example0() {
		Object nilObject = JunSmallCompiler.Evaluate_("(nil)");
		System.out.println(nilObject);
		Object trueObject = JunSmallCompiler.Evaluate_("(true)");
		System.out.println(trueObject);
		Object falseObject = JunSmallCompiler.Evaluate_("(false)");
		System.out.println(falseObject);

		return nilObject == null && trueObject instanceof Boolean && ((Boolean) trueObject).booleanValue() == true && falseObject instanceof Boolean && ((Boolean) falseObject).booleanValue() == false;
	}

	/**
	 * Example for some numbers.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Object value1 = JunSmallCompiler.Evaluate_("(123)");
		System.out.println(value1);
		Object value2 = JunSmallCompiler.Evaluate_("(123.456)");
		System.out.println(value2);
		Object value3 = JunSmallCompiler.Evaluate_("(123.456d7)");
		System.out.println(value3);
		Object value4 = JunSmallCompiler.Evaluate_("(-123)");
		System.out.println(value4);
		Object value5 = JunSmallCompiler.Evaluate_("(-123.456)");
		System.out.println(value5);
		Object value6 = JunSmallCompiler.Evaluate_("(-123.456d7)");
		System.out.println(value6);
		Object value7 = JunSmallCompiler.Evaluate_("(-123.456d-7)");
		System.out.println(value7);

		return value1 instanceof Integer
			&& ((Integer) value1).intValue() == 123
			&& value2 instanceof Float
			&& ((Float) value2).floatValue() == 123.456f
			&& value3 instanceof Double
			&& ((Double) value3).doubleValue() == 1.23456E9
			&& value4 instanceof Integer
			&& ((Integer) value4).intValue() == -123
			&& value5 instanceof Float
			&& ((Float) value5).floatValue() == -123.456
			&& value6 instanceof Double
			&& ((Double) value6).doubleValue() == -1.23456E9
			&& value7 instanceof Double
			&& ((Double) value7).doubleValue() == -1.23456E5;
	}

	/**
	 * Example for some literal values.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		Object aCharacter = JunSmallCompiler.Evaluate_("($c)");
		System.out.println(aCharacter);
		Object aString = JunSmallCompiler.Evaluate_("('string')");
		System.out.println(aString);
		Object aSymbol = JunSmallCompiler.Evaluate_("(#symbol)");
		System.out.println(aSymbol);

		return aCharacter instanceof Character && ((Character) aCharacter).charValue() == 'c' && aString instanceof String && "string".equals(aString) && aSymbol instanceof StSymbol && aSymbol == StSymbol.Intern_("symbol");
	}

	/**
	 * Example for some points.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		Object point1 = JunSmallCompiler.Evaluate_("(123 @ 456)");
		System.out.println(point1);
		Object point2 = JunSmallCompiler.Evaluate_("(123 , 456)");
		System.out.println(point2);
		Object point3 = JunSmallCompiler.Evaluate_("(123 , 456 , 789)");
		System.out.println(point3);
		Object point4 = JunSmallCompiler.Evaluate_("(Point x: 123 y: 456)");
		System.out.println(point4);
		Object point5 = JunSmallCompiler.Evaluate_("(Jun2dPoint x: 123 y: 456)");
		System.out.println(point5);
		Object point6 = JunSmallCompiler.Evaluate_("(Jun3dPoint x: 123 y: 456 z: 789)");
		System.out.println(point6);

		return point1 instanceof Jun2dPoint
			&& ((Jun2dPoint) point1).x() == 123
			&& ((Jun2dPoint) point1).y() == 456
			&& point2 instanceof Jun2dPoint
			&& ((Jun2dPoint) point2).x() == 123
			&& ((Jun2dPoint) point2).y() == 456
			&& point3 instanceof Jun3dPoint
			&& ((Jun3dPoint) point3).x() == 123
			&& ((Jun3dPoint) point3).y() == 456
			&& ((Jun3dPoint) point3).z() == 789
			&& point4 instanceof Jun2dPoint
			&& ((Jun2dPoint) point4).x() == 123
			&& ((Jun2dPoint) point4).y() == 456
			&& point5 instanceof Jun2dPoint
			&& ((Jun2dPoint) point5).x() == 123
			&& ((Jun2dPoint) point5).y() == 456
			&& point6 instanceof Jun3dPoint
			&& ((Jun3dPoint) point6).x() == 123
			&& ((Jun3dPoint) point6).y() == 456
			&& ((Jun3dPoint) point6).z() == 789;
	}

	/**
	 * Example for some colors.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		Object color1 = JunSmallCompiler.Evaluate_("(ColorValue hue: 0.57 saturation: 0.46 brightness: 1.0)");
		System.out.println(color1);
		Object color2 = JunSmallCompiler.Evaluate_("(ColorValue red: 0.57 green: 0.46 blue: 1.0)");
		System.out.println(color2);
		/*
		Object color3 = JunSmallCompiler.Evaluate_("(ColorValue cyan: 0.57 magenta: 0.46 yellow: 1.0)");
		System.out.println(color3);
		Object color4 = JunSmallCompiler.Evaluate_("(ColorValue brightness: 0.7)");
		System.out.println(color4);
		*/
		Object color5 = JunSmallCompiler.Evaluate_("(ColorValue scaledRed: 546 scaledGreen: 546 scaledBlue: 546)");
		System.out.println(color5);

		return color1 instanceof Color
			&& ((Color) color1).getRed() == 138
			&& ((Color) color1).getGreen() == 206
			&& ((Color) color1).getBlue() == 255
			&& color2 instanceof Color
			&& ((Color) color2).getRed() == 145
			&& ((Color) color2).getGreen() == 117
			&& ((Color) color2).getBlue() == 255
			&& color5 instanceof Color
			&& ((Color) color5).getRed() == 17
			&& ((Color) color5).getGreen() == 17
			&& ((Color) color5).getBlue() == 17;
	}

	/**
	 * Example for an image.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 6@7 depth: 24 bitsPerPixel: 24 palette: (FixedPalette redShift: 3 redMask: 31 greenShift: 11 greenMask: 31 blueShift: 19 blueMask: 31) usingBits: #[127 0 0 127 0 0 127 0 0 127 0 0 127 0 0 255 255 255 0 0 255 255 255 255 255 255 127 0 0 127 0 0 127 0 0 255 255 255 0 0 127 0 0 127 0 0 255 255 255 127 0 0 127 0 0 255 255 255 0 0 127 0 0 127 0 0 255 255 255 127 0 0 127 0 0 255 255 255 0 0 127 0 0 127 0 0 255 255 255 127 0 0 127 0 0 255 255 255 0 0 127 0 0 127 0 0 255 255 255 127 0 0 127 0 0 127 0 0 0 0 127 0 0 127 0 0 127 0 0 127 0 0 127 0 0 127 0 0 0 0])");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * Example for an image.
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 14@15 depth: 24 bitsPerPixel: 24 palette: (FixedPalette redShift: 3 redMask: 31 greenShift: 11 greenMask: 31 blueShift: 19 blueMask: 31) usingBits: (ByteArray fromPackedString: \'????????????????????????????@@@@????????????@@@@????????@@@@@@C???????????<@@@C???<@@@@@@@@@@@C???<@@@@@@@@@@@C???<@@O???0@@@O???????0@@@O???????0@@@O???????????0@@@O???????0@@????@@@@????????@@@@????????@@@@????????????@@@@????????@@C???<@@@C???????<@@@C???????<@@@C???????????<@@@C???????<@@O???0@@@O???????0@@@O???????0@@@O???????????????0@@@O???0@@????????????????????????????????????????????????????????@@C???????????????????????????????????????????????????????<@@O???????????????????????????????????????????????????????0@@????????????????????????????????????????????????????????@@@@@@@@@@@@@@C???????<@@@@@@@@@@@@@@@@@@@C???<@@@@@@@@@@@@@@O???????????0@@@O???0@@@O???????????????????0@@@O???????0@@????????????@@@@????@@@@@@@@@@@@@@@@????????@@@@@@@@@@@@@@C???????????<@@@C???<@@@C???????????<@@@C???<@@@C???????<@@O???0@@@@@@@O???????????????????????0@@@O???????????????0@@\'))");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * Example for an image.
	 * 
	 * @return boolean
	 */
	public static boolean Example9() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack "
					+ " usingBits: #[ "
					+ "   0 255   0 255   0 255   0 255   0 255   0 255   0 255   0 255 "
					+ " 255   0 255   0 255   0 255   0 255   0 255   0 255   0 255   0 "
					+ "   0 255   0 255   0 255   0 255   0 255   0 255   0 255   0 255 "
					+ " 255   0 255   0 255   0 255   0 255   0 255   0 255   0 255   0 "
					+ " ]) ");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * Example for an image.
	 * 
	 * @return boolean
	 */
	public static boolean ExampleX() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 32@16 depth: 24 bitsPerPixel: 24 palette: (FixedPalette redShift: 16 redMask: 255 greenShift: 8 greenMask: 255 blueShift: 0 blueMask: 255) usingBits: (ByteArray fromPackedString: '@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD?0@@?0@@?0@@?0@@?0@@?0@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@@@BD@@BD@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@?0@@??<@??<@??<@??<@??<@??<@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@@HRD@HRD@@@@?0@@?0@@?0@@?0@@?0@@?0@@??<@??<@??<@??<@??<@??<@??<@??<@??<@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@HRD@HRD@HRD@@@@@@@@@@@@@@@@??<@??<@??<@??<@??<@??<@??<@??<@??<@??<@??<@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@@O??@O??@HRD@HRD@HRD@HRD@HRD@HRD@HRD??<@??<@??<@??<@@@@@@@@@??<@??<@@@@@@@@@??<@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@O??@O??@@@@@@@@@HRD@HRD@HRD@HRD@HRD??<@??<@@@@@@@@@??<@??<@??<@??<@??<@??<@??<@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@@O??@O??@O??@O??@O??@O??@HRD@HRD@HRD@HRD@HRD@@@@@@@@??<@??<@??<@??<@??<@??<@??<@??<@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@O??@O??@O??@O??@O??@O??@O??@HRD@HRD@HRD@HRD@HRD@HRD@@@@@@@@??<@??<@??<@??<@@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@@@@@@@@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@O??@O??@O??@O??@O??@O??@O??@O??@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@O??@O??@O??@O??@O??@O??@@@@@@@@@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD@@BD'))");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunSmallCompilerTestExamples();
	}

	/**
	 * Example of an image.
	 * 
	 * @return boolean
	 */
	private static boolean Example8() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 16@16 depth: 8 bitsPerPixel: 8 "
					+ " palette: (MappedPalette withColors: ((Array new: 256) "
					+ " at: 1 put: ColorValue black; "
					+ " at: 2 put: (ColorValue scaledRed: 546 scaledGreen: 546 scaledBlue: 546); "
					+ " at: 3 put: (ColorValue scaledRed: 1092 scaledGreen: 1092 scaledBlue: 1092); "
					+ " at: 4 put: (ColorValue scaledRed: 2184 scaledGreen: 2184 scaledBlue: 2184); "
					+ " at: 5 put: (ColorValue scaledRed: 2730 scaledGreen: 2730 scaledBlue: 2730); "
					+ " at: 6 put: (ColorValue scaledRed: 3822 scaledGreen: 3822 scaledBlue: 3822); "
					+ " at: 7 put: (ColorValue scaledRed: 4369 scaledGreen: 4369 scaledBlue: 4369); "
					+ " at: 8 put: ColorValue lightGray; "
					+ " at: 9 put: (ColorValue scaledRed: 6007 scaledGreen: 6007 scaledBlue: 6007); "
					+ " at: 10 put: (ColorValue scaledRed: 7099 scaledGreen: 7099 scaledBlue: 7099); "
					+ " at: 11 put: (ColorValue scaledRed: 7645 scaledGreen: 7645 scaledBlue: 7645); "
					+ " at: 12 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 546); "
					+ " at: 13 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 1092); "
					+ " at: 14 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 2184); "
					+ " at: 15 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 2730); "
					+ " at: 16 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 3822); "
					+ " at: 17 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 4369); "
					+ " at: 18 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 5461); "
					+ " at: 19 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 6007); "
					+ " at: 20 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 7099); "
					+ " at: 21 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 7645); "
					+ " at: 22 put: (ColorValue scaledRed: 0 scaledGreen: 546 scaledBlue: 0); "
					+ " at: 23 put: (ColorValue scaledRed: 0 scaledGreen: 1092 scaledBlue: 0); "
					+ " at: 24 put: (ColorValue scaledRed: 0 scaledGreen: 2184 scaledBlue: 0); "
					+ " at: 25 put: (ColorValue scaledRed: 0 scaledGreen: 2730 scaledBlue: 0); "
					+ " at: 26 put: (ColorValue scaledRed: 0 scaledGreen: 3822 scaledBlue: 0); "
					+ " at: 27 put: (ColorValue scaledRed: 0 scaledGreen: 4369 scaledBlue: 0); "
					+ " at: 28 put: (ColorValue scaledRed: 0 scaledGreen: 5461 scaledBlue: 0); "
					+ " at: 29 put: (ColorValue scaledRed: 0 scaledGreen: 6007 scaledBlue: 0); "
					+ " at: 30 put: (ColorValue scaledRed: 0 scaledGreen: 7099 scaledBlue: 0); "
					+ " at: 31 put: (ColorValue scaledRed: 0 scaledGreen: 7645 scaledBlue: 0); "
					+ " at: 32 put: (ColorValue scaledRed: 546 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 33 put: (ColorValue scaledRed: 1092 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 34 put: (ColorValue scaledRed: 2184 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 35 put: (ColorValue scaledRed: 2730 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 36 put: (ColorValue scaledRed: 3822 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 37 put: (ColorValue scaledRed: 4369 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 38 put: (ColorValue scaledRed: 5461 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 39 put: (ColorValue scaledRed: 6007 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 40 put: (ColorValue scaledRed: 7099 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 41 put: (ColorValue scaledRed: 7645 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 42 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 43 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 44 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 45 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 46 put: ColorValue blue; "
					+ " at: 47 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 48 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 49 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 50 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 51 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 52 put: (ColorValue scaledRed: 0 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 53 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 54 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 55 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 56 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 57 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 58 put: (ColorValue scaledRed: 0 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 59 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 60 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 61 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 62 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 63 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 64 put: (ColorValue scaledRed: 0 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 65 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 66 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 67 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 68 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 69 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 70 put: (ColorValue scaledRed: 0 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 71 put: ColorValue green; "
					+ " at: 72 put: (ColorValue scaledRed: 0 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 73 put: (ColorValue scaledRed: 0 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 74 put: (ColorValue scaledRed: 0 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 75 put: (ColorValue scaledRed: 0 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 76 put: ColorValue cyan; "
					+ " at: 77 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 78 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 79 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 80 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 81 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 82 put: (ColorValue scaledRed: 1638 scaledGreen: 0 scaledBlue: 8191); "
					+ " at: 83 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 84 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 85 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 86 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 87 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 88 put: (ColorValue scaledRed: 1638 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 89 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 90 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 91 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 92 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 93 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 94 put: (ColorValue scaledRed: 1638 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 95 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 96 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 97 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 98 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 99 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 100 put: (ColorValue scaledRed: 1638 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 101 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 102 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 103 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 104 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 105 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 106 put: (ColorValue scaledRed: 1638 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 107 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 0); "
					+ " at: 108 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 109 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 110 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 111 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 112 put: (ColorValue scaledRed: 1638 scaledGreen: 8191 scaledBlue: 8191); "
					+ " at: 113 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 114 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 115 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 116 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 117 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 118 put: (ColorValue scaledRed: 3276 scaledGreen: 0 scaledBlue: 8191); "
					+ " at: 119 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 120 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 121 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 122 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 123 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 124 put: (ColorValue scaledRed: 3276 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 125 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 126 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 127 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 128 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 129 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 130 put: (ColorValue scaledRed: 3276 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 131 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 132 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 133 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 134 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 135 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 136 put: (ColorValue scaledRed: 3276 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 137 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 138 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 139 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 140 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 141 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 142 put: (ColorValue scaledRed: 3276 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 143 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 0); "
					+ " at: 144 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 145 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 146 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 147 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 148 put: (ColorValue scaledRed: 3276 scaledGreen: 8191 scaledBlue: 8191); "
					+ " at: 149 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 150 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 151 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 152 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 153 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 154 put: (ColorValue scaledRed: 4915 scaledGreen: 0 scaledBlue: 8191); "
					+ " at: 155 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 156 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 157 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 158 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 159 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 160 put: (ColorValue scaledRed: 4915 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 161 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 162 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 163 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 164 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 165 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 166 put: (ColorValue scaledRed: 4915 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 167 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 168 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 169 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 170 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 171 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 172 put: (ColorValue scaledRed: 4915 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 173 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 174 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 175 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 176 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 177 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 178 put: (ColorValue scaledRed: 4915 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 179 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 0); "
					+ " at: 180 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 181 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 182 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 183 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 184 put: (ColorValue scaledRed: 4915 scaledGreen: 8191 scaledBlue: 8191); "
					+ " at: 185 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 0); "
					+ " at: 186 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 187 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 188 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 189 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 190 put: (ColorValue scaledRed: 6553 scaledGreen: 0 scaledBlue: 8191); "
					+ " at: 191 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 192 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 193 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 194 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 195 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 196 put: (ColorValue scaledRed: 6553 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 197 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 198 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 199 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 200 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 201 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 202 put: (ColorValue scaledRed: 6553 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 203 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 204 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 205 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 206 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 207 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 208 put: (ColorValue scaledRed: 6553 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 209 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 210 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 211 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 212 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 213 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 214 put: (ColorValue scaledRed: 6553 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 215 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 0); "
					+ " at: 216 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 217 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 218 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 219 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 220 put: (ColorValue scaledRed: 6553 scaledGreen: 8191 scaledBlue: 8191); "
					+ " at: 221 put: ColorValue red; "
					+ " at: 222 put: (ColorValue scaledRed: 8191 scaledGreen: 0 scaledBlue: 1638); "
					+ " at: 223 put: (ColorValue scaledRed: 8191 scaledGreen: 0 scaledBlue: 3276); "
					+ " at: 224 put: (ColorValue scaledRed: 8191 scaledGreen: 0 scaledBlue: 4915); "
					+ " at: 225 put: (ColorValue scaledRed: 8191 scaledGreen: 0 scaledBlue: 6553); "
					+ " at: 226 put: ColorValue magenta; "
					+ " at: 227 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 0); "
					+ " at: 228 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 1638); "
					+ " at: 229 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 3276); "
					+ " at: 230 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 4915); "
					+ " at: 231 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 6553); "
					+ " at: 232 put: (ColorValue scaledRed: 8191 scaledGreen: 1638 scaledBlue: 8191); "
					+ " at: 233 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 0); "
					+ " at: 234 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 1638); "
					+ " at: 235 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 3276); "
					+ " at: 236 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 4915); "
					+ " at: 237 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 6553); "
					+ " at: 238 put: (ColorValue scaledRed: 8191 scaledGreen: 3276 scaledBlue: 8191); "
					+ " at: 239 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 0); "
					+ " at: 240 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 1638); "
					+ " at: 241 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 3276); "
					+ " at: 242 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 4915); "
					+ " at: 243 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 6553); "
					+ " at: 244 put: (ColorValue scaledRed: 8191 scaledGreen: 4915 scaledBlue: 8191); "
					+ " at: 245 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 0); "
					+ " at: 246 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 1638); "
					+ " at: 247 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 3276); "
					+ " at: 248 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 4915); "
					+ " at: 249 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 6553); "
					+ " at: 250 put: (ColorValue scaledRed: 8191 scaledGreen: 6553 scaledBlue: 8191); "
					+ " at: 251 put: ColorValue yellow; "
					+ " at: 252 put: (ColorValue scaledRed: 8191 scaledGreen: 8191 scaledBlue: 1638); "
					+ " at: 253 put: (ColorValue scaledRed: 8191 scaledGreen: 8191 scaledBlue: 3276); "
					+ " at: 254 put: (ColorValue scaledRed: 8191 scaledGreen: 8191 scaledBlue: 4915); "
					+ " at: 255 put: (ColorValue scaledRed: 8191 scaledGreen: 8191 scaledBlue: 6553); "
					+ " at: 256 put: ColorValue white; yourself)) "
					+ " usingBits: #[ "
					+ " 255 255 255 255 255 255 250  70 255 255 255 255 255 255 255 255 "
					+ " 255 255 255 255 255 255  45 220 255 255 255 255 255 255 255 255 "
					+ " 255 255 255 255 250  70 255 255 250  70 255 255 255 255 255 255 "
					+ " 255 255 255 255  45 220 255 255  45 220 255 255 255 255 255 255 "
					+ " 255 255 255 255 250  70 255 255 250  70 255 255 255 255 255 255 "
					+ " 255 255 255 255  45 220 255 255  45 220 255 255 255 255 255 255 "
					+ " 255 255 250  70 250  70 255 255 250  70 255 255 255 255 255 255 "
					+ " 255 255  45 220  45 220 255 255  45 220 255 255 255 255 255 255 "
					+ " 255 255 250  70 250  70 250  70 250  70 250  70 255 255 255 255 "
					+ " 255 255  45 220  45 220  45 220  45 220  45 220 255 255 255 255 "
					+ " 255 255 250  70 255 255 255 255 255 255 250  70 255 255 255 255 "
					+ " 255 255  45 220 255 255 255 255 255 255  45 220 255 255 255 255 "
					+ " 255 255 250  70 255 255 255 255 255 255 250  70 250  70 255 255 "
					+ " 255 255  45 220 255 255 255 255 255 255  45 220  45 220 255 255 "
					+ " 250  70 250  70 255 255 255 255 255 255 255 255 250  70 250  70 "
					+ "  45 220  45 220 255 255 255 255 255 255 255 255  45 220  45 220 "
					+ " ]) ");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * Example for an image.
	 * 
	 * @return boolean
	 */
	private static boolean Example9x() {
		Object anImage =
			JunSmallCompiler.Evaluate_(
				"(Image extent: 16@16 depth: 1 bitsPerPixel: 1 palette: (MappedPalette withColors: ((Array new: 2) at: 1 put: (ColorValue scaledRed: 8191 scaledGreen: 8191 scaledBlue: 8191); at: 2 put: (ColorValue scaledRed: 0 scaledGreen: 0 scaledBlue: 0);  yourself)) usingBits: #[0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 255 0 0 0 255 0 0 0 255 0 0 0 255 0 0 0])");
		JunDisplayModel.Show_(anImage);

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 * 
	 * @throws Exception DOCUMENT ME!
	 */
	private static boolean ExampleY() throws Exception {
		java.awt.FileDialog fileDialog = new java.awt.FileDialog(new java.awt.Frame());
		fileDialog.setVisible(true);
		String directory = fileDialog.getDirectory();
		String filename = fileDialog.getFile();
		if ((directory == null) || (filename == null)) {
			return false;
		}

		java.io.File file = new java.io.File(directory, filename);
		int fileSize = (int) (file.length());
		char[] lispString = new char[fileSize];
		java.io.FileReader fr = new java.io.FileReader(file);
		int positionOfFS = 0;
		while (positionOfFS < fileSize) {
			int rNumber = fr.read(lispString, positionOfFS, fileSize - positionOfFS);
			positionOfFS += rNumber;
		}

		StImage image = (StImage) JunSmallCompiler.Evaluate_(String.valueOf(lispString));
		image._display();

		return true;
	}
}
